package LCM::Configuration::ValueChangeListeners::RemoveHosts::LSSParameterListener;

use strict;
use warnings;

use parent qw( LCM::Configuration::ValueChangeListeners::LSSParameterListener );
use SDB::Install::Globals qw($gHostRoleWorker $gHostRoleStandby);

sub shouldSkipLssParams {
    my ($self, $value, $configuration) = @_;
    return 1 if($self->SUPER::shouldSkipLssParams($value, $configuration));
    my $detector = $configuration->getRemoveHostsDetector();
    my $removeHosts = $detector->getHostsFromUserInput($value) // [];
    my $isRemovingDbHost = grep { $detector->isHostInRole($_, $gHostRoleStandby) || $detector->isHostInRole($_, $gHostRoleWorker) } @{$removeHosts};
    return !$isRemovingDbHost;
}

1;
