package LCM::Configuration::ValueChangeListeners::Rename::CertificatesHostmapListener;

use strict;

my $ERROR_MESSAGE = 'Failed to detect external host names default values';

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $exitCode = $instconfig->fillCertificatesHostmapDefaultValuesAndLocalData();

    if(!$exitCode) {
        $instconfig->getErrMsgLst()->addMessage($ERROR_MESSAGE);
        return undef;
    }
    return 1;
}

sub onMapValueChange {
    my ($self, $key, $value, $instconfig) = @_;
    my $exitCode = $instconfig->fillCertificatesHostmapDefaultValuesAndLocalData();

    if(!$exitCode) {
        $instconfig->getErrMsgLst()->addMessage($ERROR_MESSAGE);
        return undef;
    }
    return 1;
}

1;
