package LCM::Configuration::ValueChangeListeners::Rename::XsSpaceIsolation;

use strict;
use SDB::Install::User;
use LCM::App::ApplicationContext;
use SDB::Common::Utils qw(createXSSpaceSAPUserName createXSSpaceProdUserName);
use SDB::Install::Configuration qw($bool_true_pattern);

my $PARAMETER_ID_INSTANCE_NUMBER = 'InstanceNumber';
my $PARAMETER_ID_SAP = 'XSSpaceUserIdSAP';
my $PARAMETER_ID_PROD = 'XSSpaceUserIdProd';
my $UID_PARAMETER_IDS = [ 'UID', $PARAMETER_ID_SAP, $PARAMETER_ID_PROD ];

sub new {
    return bless({}, shift());
}

sub handleOsUsers {
    my ($self, $configuration) = @_;
    my $userNameSAP = createXSSpaceSAPUserName($configuration->getValue('newSID'));
    my $userNameProd = createXSSpaceProdUserName($configuration->getValue('newSID'));

    if(!$self->_handleOsUserId($configuration, $userNameSAP, $PARAMETER_ID_SAP)){
        $configuration->setNoRetry($PARAMETER_ID_INSTANCE_NUMBER, 1);
        return undef;
    }
    if(!$self->_handleOsUserId($configuration, $userNameProd, $PARAMETER_ID_PROD)){
        $configuration->setNoRetry($PARAMETER_ID_INSTANCE_NUMBER, 1);
        return undef;
    }
    return 1;
}

sub _handleOsUserId {
    my ($self, $configuration, $userName, $parameterId) = @_;
    my $applicationContext = LCM::App::ApplicationContext::getInstance();

    if($configuration->isSkipped($parameterId)){
        return 1;
    }
    my $existingId = $configuration->getExistingUserId($userName);
    if(defined($existingId)){
        return $configuration->handleExistingOsID($existingId, $parameterId);
    }
    if($applicationContext->getMode() =~ /^CLI|Batch$/){
        $self->_updateUIStringByTemplate($configuration, $userName, $parameterId);
    }
    $configuration->handleDefaultUserId($parameterId);
    return 1;
}

sub _updateUIStringByTemplate {
    my ($self, $configuration, $userName, $parameterId) = @_;
    my $parameter = $configuration->{params}->{$parameterId};

    if(defined($parameter) && defined($parameter->{str_templ})){
        $parameter->{str} = sprintf($parameter->{str_templ}, $userName);
    }
}

1;
