package LCM::Configuration::ValueChangeListeners::ReservedIDsHandler;

use strict;
use SDB::Install::Globals qw($gKeynameLSS);

sub new {
    my ($class, $paramId, $isUID) = @_;
    my $self = bless( {}, shift );
    $self->{paramID} = $paramId;
    $self->{isUID} = $isUID;
    return $self;
}

sub onValueChange {
    my ($self, $value, $config) = @_;

    my $paramID = $self->{paramID};
    if ($self->{isUID}){
        $config->addReservedUserID($paramID, $value);
    } else {
        $config->addReservedGroupID($paramID, $value);
    }

    if ($paramID eq 'UID' && $self->_isLSSPartOfSystem($config)){
        $config->initLSSUserID();
    }
    if ($paramID eq 'GID' && $self->_isLSSPartOfSystem($config)){
        $config->initLSSGroupID();
    }
    return 1;
}

sub _isLSSPartOfSystem {
    my ($self, $config) = @_;
    return $config->isComponentSelected($gKeynameLSS);
}

sub configurationChanged {
    my ($self, $event) = @_;
    return if (! defined $event || $event->{property} ne 'skip');

    my $userPattern = '(^UID$|UserI[dD])';
    my $groupPattern = '(^GID$|GroupI[dD])';
    if($event->{newValue} == 1 && $event->{paramId} =~ /$userPattern/){
        $event->{config}->deleteUnnesessaryReservedUserIDs();
    } elsif($event->{newValue} == 1 && $event->{paramId} =~ /$groupPattern/) {
        $event->{config}->deleteUnnesessaryReservedGroupIDs();
    }
}

1;
