package LCM::Configuration::ValueChangeListeners::ResidentUpdateComponentDetectionListener;

use SDB::Install::SysVars qw ($isWin $path_separator);
use LCM::Configuration::ValueChangeListeners::Update::SIDHelper;
use SDB::Common::Utils qw(trim);

sub new {
	my ($class, $parameterId) = @_;
	my $self = {
		_parameterId => $parameterId,
	};
	return bless($self, $class);
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;
	my $sid = $instconfig->getValue('SID');
	my $sapSys = $instconfig->getCollectSAPSystems()->{$sid};

	if ( defined $instconfig->{params}->{Password} ) {
		if (! LCM::Configuration::ValueChangeListeners::Update::SIDHelper::InitConfigUsername($instconfig, $sid)) {
			$instconfig->{params}->{DvdPath}->{no_retry} = 1;
			$instconfig->{params}->{ComponentDirs}->{no_retry} = 1;
			$instconfig->{params}->{ComponentFsRoot}->{no_retry} = 1;
			return 0;
		}
	}

	if (defined $sapSys) {
		my $target = $sapSys->get_target();
		my $params = $instconfig->{params};
		my $globalSidDir = $isWin ? $sapSys->getUsrSapSid() : $sapSys->get_globalSidDir();
		$target = substr($globalSidDir, 0, -4) if (!defined $target || length(trim($target)) == 0);
		my $base_value = $target . $path_separator . $sid . $path_separator;
        $instconfig->setDefault('ClientPath', $base_value . "hdbclient");
		$instconfig->setDefault('StudioPath', $base_value . "hdbstudio");

		if (!$isWin) {
			my $instance  = $sapSys->getNewDBInstances()->[0];
			my $rHostlist = $instance->get_hosts() if (defined $instance);

			$params->{Target}->{value} = $target;
			$params->{RootUser}->{skip} = 0 if (defined $rHostlist && scalar (@$rHostlist) > 0);
		}
	}

	return undef if (! $instconfig->detectInstalledComponents($sid));
	return undef if (! $instconfig->initializeSelectedComponents());
	return 1;
}

1;