package LCM::Configuration::ValueChangeListeners::Uninstall::LSSParameterListener;

use strict;
use warnings;

use parent qw(LCM::Configuration::ValueChangeListeners::LSSParameterListener);
use SDB::Install::Globals qw ( $gKeynameLSS );

sub shouldSkipLssParams {
    my($self, $value, $configuration) = @_;
    return 1 if($self->SUPER::shouldSkipLssParams($value, $configuration));
    my $componentManager = $configuration->getSystemComponentManager();
    return !$componentManager->isComponentSelected($gKeynameLSS);
}

sub skipLssUserParams {
    my($self,$configuration,$skip) = @_;
    $self->SUPER::skipLssUserParams($configuration,$skip);

    foreach my $paramId ('LSSInstallationPath', 'KeepLSSUser', 'KeepLSSUserGroup') {
        $configuration->setSkip($paramId,$skip);
    }

    if(!$skip){
        my $lssInstance = $configuration->getOwnInstance()->getLssInstance();
        $lssInstance->setMsgLstContext($configuration->getMsgLstContext());
        $configuration->setValue('LSSInstallationPath', $lssInstance->getLssSidDir());
        $configuration->setInteractive('KeepLSSUser', 1);
        $configuration->setInteractive('KeepLSSUserGroup', 1);
    }
}

1;