package LCM::Configuration::ValueChangeListeners::Uninstall::NameserverConnectivityListener;

use strict;
use LCM::App::ApplicationContext;

use SDB::Install::Globals qw($gProductNameEngine $gKeynameEngine);
use LCM::Utils::RemoveHosts qw(IsRemovingLocalHost IsRemovingRemoteHost);
use LCM::Utils::RemoveRoles qw(IsRemovingLocalRole IsRemovingRemoteRole);

sub new { return bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $configuration) = @_;

    if(!$self->_shallTestNameserverConnectivity($configuration)){
        return 1;
    }
    if($self->_testNameserverConnectivity($configuration)){
        return 1;
    }
    my $applicationContext = LCM::App::ApplicationContext::getInstance();
    my $hdblcmMode = $applicationContext->getMode();
    my $shallSetNoRetry = $hdblcmMode eq 'CLI' ? 1 : 0;
    $configuration->setNoRetry('ForceRemoveHosts', $shallSetNoRetry);
    return undef;
}

sub _shallTestNameserverConnectivity {
    my ($self, $configuration) = @_;
    my $componentManager = $configuration->getSystemComponentManager();

    return 0 if($componentManager->isComponentSelected($gKeynameEngine));
    return 1 if(IsRemovingLocalHost($configuration));
    return 1 if(IsRemovingRemoteHost($configuration));
    return 1 if(IsRemovingLocalRole($configuration));
    return 1 if(IsRemovingRemoteRole($configuration));
    return 0;
}

sub _testNameserverConnectivity {
    my ($self, $configuration) = @_;
    my $trexInstance = $configuration->getOwnInstance();
    my $message = $configuration->getMsgLst()->addProgressMessage('Testing connectivity to the master nameserver ...');
    my $subMessageList = $message->getSubMsgLst();
    my $returnCode = $trexInstance->pingMasterNameServer($subMessageList);

    if (!defined($returnCode)){
        $configuration->getErrMsgLst()->addError('Master nameserver is not available', $message);
        $configuration->getErrMsgLst()->addError("Start $gProductNameEngine on master host");
        return undef;
    }
    return 1;
}

1;
