package LCM::Configuration::ValueChangeListeners::Update::NonRootRemoteHostsAuthenticationListener;
use parent qw (LCM::Configuration::ValueChangeListeners::PostCollectHostInfoChecksListener);

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new { return bless ({}, shift()); }

sub onValueChange {
	my ($self, $value, $config) = @_;

	if(!$config->isUseSidadmUserForRemoteHostctrlHosts() && !$config->isUseSAPHostagent()){
		return 1;
	}
	if (! $self->checkCollectedHostInfo($config)) {
		return 0;
	}

	require LCM::Configuration::ValueChangeListeners::FillingCertificatesListener;
	my $fillingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::FillingCertificatesListener();
	$fillingCertificatesHelper->onValueChange( $value, $config );

	require LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator;
	my $skippingCertificatesHelper = new LCM::Configuration::ValueChangeListeners::CertificatesSkipValueConfigurator();
	$skippingCertificatesHelper->configureSkippingCertificates($config);

	$config->setupInterServiceCommunicationParameters();
	if (!$config->initLSSGroupAndUserID()){
        return 0;
    }

	return 1;
}

1;
