package LCM::Configuration::ValueChangeListeners::Update::RemoteExecutionListener;

use strict;

sub new {
    my ($class, ) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	if ($value eq 'saphostagent') {
		$instconfig->setUseSidadmUserForRemoteHostctrlHosts(1);
# Here we make the strong assumption that RemoteExecution parameter is set only once - in the begining of the execution
# and any changes in a later point will be made when _recomputeRequiredParameters is called.
# This way we workaround the problem, described with Bug: 81070
		$instconfig->setSkip('RootUser', 1);
		$instconfig->setSkip('RootPassword', 1);
	}

	return 1;
}

1;
