package LCM::Configuration::ValueChangeListeners::Update::SystemDBUseSingleDBUserPasswordListener;

use strict;
use warnings;

sub new {
    my ($class, ) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}


sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $app = LCM::App::ApplicationContext::getInstance()->getApplication();
    my $SystemDBSQLPasswordBatchValue = $configuration->getBatchValue('SystemDBSQLPassword');
    my $isSingleDb = $configuration->isSingleTenantSystem();

    if ($app->isBatchMode() &&  $value && (defined $SystemDBSQLPasswordBatchValue) && $isSingleDb) {
    	$configuration->setErrorMessage("Parameter systemdb_system_user_password can not be used together with systemdb_use_singledb_user_password.", $configuration->getErrMsgLst());
        return 0;
    }

    return 1;
}

1;