package LCM::Configuration::ValueChangeListeners::XsInitTenantDatabaseListener;

use strict;
use SDB::Install::Globals qw($gKeynameXS2);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    return 1 if (!$instconfig->isComponentSelected($gKeynameXS2) || $instconfig->isSingleTenantSystem()) ;
    $self->setValidValues($instconfig);
    return 1;
}

sub setValidValues{
    my ($self, $cfg) = @_;
    my $instance = $cfg->getOwnInstance();
    my @tenantNames = map{ $_->getName() } @{$instance->getTenantDatabases()};
    push( @{$cfg->getValidValues('XSTenantDatabaseName')}, @tenantNames);
}

1;