package LCM::Configuration::Web::AddHostRolesConfiguration;

use strict;
use parent qw(LCM::Configuration::AddHostRolesConfiguration);
use LCM::App::AddHostRolesUtils qw(getPossibleRolesForExistingHosts);
use LCM::Configuration::ParametersCreator qw(GetParamExistingHosts GetParamIgnore);
use LCM::Configuration::ValueChangeListeners::FillingRolesHostmapListener;

sub new {
    my $self = shift()->SUPER::new(@_);

    for my $parameterId ('Target', 'SID', 'RemoteExecution', 'InstallSSHKey'){
        $self->setHidden($parameterId, 1);
    }
    $self->setValue('RemoteExecution', 'saphostagent');
    $self->_addSlpSpecificParameters();

    return $self;
}

sub _addListeners {
    my $self = shift();
    $self->SUPER::_addListeners(@_);
    $self->addParameterListener('SID', sub {
        $self->_initParamExistingHosts();
        $self->_initParamAvailableHostRoles();
    });
}

sub checkAddRoles {
    my ($self, $host, $roles) = @_;
    return 1 if($roles eq '');
    return $self->SUPER::checkAddRoles($host, $roles);
}

sub setAddRoles {
    my ($self, $host, $roles) = @_;
    return $self->SUPER::setAddRoles($host, $roles) if($roles ne '');
    delete($self->{params}->{AddRoles}->{value}->{$host});
    return 1;
}

sub _initParamExistingHosts {
    my ($self) = @_;
    my $existingHostsParameter = $self->{params}->{ExistingHosts};
    my $instance = $self->getOwnInstance(1);
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my @existingHostsWithRoles = map { "${_}:role=" . join(':role=', split('\s+', $hostRolesInfo->{$_})) } @{$self->getSystemHosts()};

    $existingHostsParameter->{value} = join(',', @existingHostsWithRoles);
}

sub _initParamAvailableHostRoles {
    my ($self) = @_;
    my $availableHostRolesParameter = $self->{params}->{AvailableHostRoles};
    my $existingHostToValidRolesMap = getPossibleRolesForExistingHosts($self);
    my $instance = $self->getOwnInstance(1);
    my $hostRolesInfo = $instance->getHostRolesInfo();
    my @result = ();

    for my $host (@{$self->getSystemHosts()}) {
        my @assignedRoles = split('\s+', $hostRolesInfo->{$host});
        my @availableRoles = exists($existingHostToValidRolesMap->{$host}) ? @{$existingHostToValidRolesMap->{$host}} : ();
        my $validHostRolesString = "$host:role=" . join(':role=', @assignedRoles, @availableRoles);
        push(@result, $validHostRolesString);
    }

    $availableHostRolesParameter->{value} = join(',', @result);
}

sub _addSlpSpecificParameters {
    my ($self) = @_;
    my $order = scalar(keys(%{$self->{params}}));
    my $section = $self->{params}->{AddRoles}->{section};

    $self->{params}->{ExistingHosts} = GetParamExistingHosts($order++, $section);
    $self->{params}->{AvailableHostRoles} = $self->_getParamAvailableHostRoles($order++, $section);

    my $ignoreValues = $self->getIgnoreValues();
    if(defined($ignoreValues) && scalar(@{$ignoreValues})){
        $self->{params}->{Ignore} = GetParamIgnore($order++, $section, $ignoreValues);
    }
}

sub _getParamAvailableHostRoles {
    my ($self, $order, $section) = @_;
    return {
        'order'             => $order,
        'opt'               => 'available_host_roles',
        'type'              => 'string',
        'section'           => $section,
        'value'             => undef,
        'init_with_default' => 0,
        'set_interactive'   => 0,
        'str'               => 'Available Host Roles',
        'mandatory'         => 0,
    };
}

1;