package LCM::Configuration::Web::DetectSystemInformationConfiguration;

use strict;
use LCM::SLD::SldregUtility;
use SDB::Install::Configuration qw ($bool_true_pattern);
use SDB::Install::SysVars;
use LCM::Installer;

our @ISA = qw (SDB::Install::Configuration::AnyConfig);

sub new {
    my $self = shift->SUPER::new (@_);

    my $order = 0;
    $self->{params} = {
		'SID' => $self->getParamSID($order++, undef),
		'InstanceNumber' => $self->_getParamInstanceNumber('number'),
		'InstallationPath' => $self->_getParamInstallationPath('path'),
		'DataPath' => $self->_getParamDataPath('path'),
		'LogPath' => $self->_getParamLogPath('path'),
		'ServerVersion' => $self->_getParamServerVersion('number'),
		'Hosts' => $self->_getParamHosts('mapping_list'),
		'Components' => $self->_getParamComponents('mapping_list'),
		'DBMode' => $self->_getParamDBMode('string'),
		'SystemUsage' => $self->_getParamSystemUsage('string'),
		'ListenInterface' => $self->_getParamListenInterface('string'),
		'InternalNetwork' => $self->_getParamInternalNetwork('string'),
        'LCMVersion' => $self->_getParamLCMVersion('string'),
        # SLD specific parameters
        'SLDHostname' => $self->_createGenericParameter('string'),
        'SLDPort' => $self->_createGenericParameter('number'),
        'SLDUsername' => $self->_createGenericParameter('string'),
        'UseHTTPS' => $self->_createGenericParameter('boolean'),

    };

	return $self;
}

sub InitDefaults {
    my ($self) = @_;
    my $instance = $self->getOwnInstance();

    if ($instance) {
        $self->_fillSldProperties($instance);
    }

	return 1;
}

sub _fillSldProperties {
    my ($self) = @_;
    my $sldreg = LCM::SLD::SldregUtility->new($self);
    my $storedParams = $sldreg->getStoredSLDProperties();

    for my $paramId (keys %{$storedParams}) {
        my $paramType = $self->getType($paramId);
        my $storedValue = $storedParams->{$paramId};
        next if $paramType =~ /passwd/;

        my $realValue = $paramType eq 'boolean' ? ($storedValue =~ $bool_true_pattern ? 1 : 0) : $storedValue;
        $self->{params}->{$paramId}->{value} = $realValue;
    }

}

sub _createGenericParameter {
    my ($self, $type) = @_;
    return {
        type => $type,
        value => undef,
    };
}

sub _getParamInstanceNumber{
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->get_nr();
    }

    return $param;
}

sub _getParamInstallationPath {
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $system = $self->getSAPSystem();

    if (defined $system) {
        $param->{value} = $system->get_target();
    }

    return $param;
}

sub _getParamDataPath {
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->getDataPath(1);
    }

    return $param;
}

sub _getParamLogPath {
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->getLogPath(1);
    }

    return $param;
}

sub _getParamHosts {
	my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
   my $instance = $self->getOwnInstance();

	if (defined $instance) {
		my $hosts = $instance->get_allhosts();
		my $hostRolesInfo = $instance->getHostRolesInfo();
		
		
        my $hostsHash = {};
        for my $host (@$hosts) {
			my $roles = join(',', split('\s', $hostRolesInfo->{$host}));
			$hostsHash->{$host} = "Roles: $roles";
        }
        $param->{value} = $hostsHash;
    }

    return $param;
}

sub _getAllComponents {
	my ($self, $type) = @_;

    my $scm = $self->_getInstaller()->getOwnSystemComponentManager();
    my $components;

    if (defined $scm){
        $components = $scm->getAllComponents();
    }

    return $components;
}

sub _getParamComponents {
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $components = $self->_getAllComponents();

    if (defined $components){
        my $componentsHash = {};
        for my $cmp (@$components) {
			if ( not $cmp->isInternal() ) {
				my $cmpName = $cmp->getComponentName();
				$componentsHash->{$cmpName} = $cmp->getVersion();
			}
        }
        $param->{value} = $componentsHash;
    }

    return $param;
}

sub _getParamServerVersion {
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $components = $self->_getAllComponents();

    if (defined $components){
        for my $cmp (@$components) {
			if ($cmp->isServer()){
				$param->{value} = $cmp->getVersion();
			}
        }
    }

    return $param;
}

sub _getParamDBMode{
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->getDbMode();
    }

    return $param;
}

sub _getParamSystemUsage{
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->getSystemUsage();
    }

    return $param;
}

sub getListenInterfaceType {
    my ($self) = @_;
    my $interfaceType = $self->getOwnInstance()->getTrexNetListenInterface();
    return (defined $interfaceType) ? substr($interfaceType, 1) : 'local';
}

sub _getParamListenInterface{
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    $param->{value} = $self->getListenInterfaceType();

    return $param;
}

sub _getParamInternalNetwork{
    my ($self, $type) = @_;

    my $param = {   type => $type,
                    value => undef,
                };
    my $instance = $self->getOwnInstance();

    if (defined $instance) {
        $param->{value} = $instance->getInternalNetworkPrefix();
    }

    return $param;
}

sub _getInstaller {
    my ($self) = @_;

    if (not defined $self->{installer}) {
        $self->{installer} = new LCM::Installer();
    }

    return $self->{installer};
}

sub getSAPSystem {
    my ($self) = @_;

    if (not defined $self->{system}) {
        $self->{system} = $self->_getInstaller()->getOwnSapSystem();
    }

    return $self->{system};
}

sub _getParamLCMVersion {
    my ($self, $type) = @_;
    my $param = $self->_createGenericParameter($type);
    my $installer = LCM::Installer->new(undef, $self);
    $param->{value} = $installer->getFullVersion();
    return $param;
}

1;
