package LCM::ExecutionWarningsObservable;
use strict;
our $instance = undef;

sub _new {
	my ($class) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub getInstance {
	if ( !defined $instance ) {
		$instance = LCM::ExecutionWarningsObservable->_new();
	}
	return $instance;
}

sub registerListener {
	my ( $self, $messageHandler ) = @_;
	if ( !defined $messageHandler ) {
		return;
	}
	if (!defined $self->{_handlers}) {
		$self->{_handlers} = [];
	}
	push( @{$self->{_handlers}}, $messageHandler );
}

sub unregisterListener {
	my ( $self, $messageHandler ) = @_;
	if ( !defined $messageHandler ) {
		return;
	}
	my $counter = 0;
	foreach my $listener ( @{ $self->{_handlers} } ) {
		if ( $listener eq $messageHandler ) {
			splice( @{ $self->{_handlers} }, $counter, 1 );
		}
		$counter++;
	}
}

sub notifyWarning {
	my ( $self, $message ) = @_;
	foreach my $listener ( @{ $self->{_handlers} } ) {
		$listener->onWarning($message);
	}
}

return 1;
