package LCM::Executors::CheckCertificatesExecutor;

use strict;
use base qw (LCM::Executors::BaseExecutor);

sub new {
    my ( $class, $config ) = @_;
    my $self = $class->SUPER::new();
    $self->{config} = $config;

    return $self;
}

sub execute {
    my ($self) = @_;
    my $resultOnLocalHost = $self->_executeOnLocalHost();
    my $resultOnRemoteHosts = $self->_executeOnRemoteHosts();

    return $resultOnLocalHost  || $resultOnRemoteHosts ;
}

sub _executeOnLocalHost {
    my ( $self, ) = @_;
    my $config = $self->{config};
    my $instance = $config->getOwnInstance();
    my $localHost = $instance->get_host();
    my $ownHostValue = $config->{CertificatesHostmap}->{$localHost};

    return _needsRegeneration($ownHostValue);
}

sub _executeOnRemoteHosts {
    my ( $self, ) = @_;
    my $remoteHostsObjects = $self->{config}->getRemoteHostsObjects() || [];

    for my $remoteHosts (@{$remoteHostsObjects}){
        my $hostNames = $remoteHosts->getHostNames();

        next if (!defined($hostNames));

        for my $hostName ( @{$hostNames} ) {
            my $ownHostValue = $self->{config}->{CertificatesHostmap}->{$hostName};
            return 1 if(_needsRegeneration($ownHostValue));
        }
    }
    return 0;
}

sub _needsRegeneration{
    my ($value) = @_;
    return ( ! defined $value || $value eq '' );
}

1;
