package LCM::Fcgi::App::EnvironmentUtilities;

use strict;
use parent 'Exporter';
use File::Spec;

use SDB::Install::SAPSystem qw(CollectSAPSystems);

our @EXPORT = qw(PrepareExecutionEnvironment);

my $getHdbInstance = sub {
	my ($sid) = @_;
	my $allSystems = CollectSAPSystems( undef, 1 );
	my $ownSystem = $allSystems->{$sid};

	if (defined($ownSystem) && $ownSystem->hasNewDB()){
		return $ownSystem->getNewDBInstances()->[0];
	}
	return undef;
};

sub PrepareExecutionEnvironment {
	my ($sid) = @_;
	my $hdbInstance  = $getHdbInstance->($sid);

	return if(!defined($hdbInstance));

	my $hanaExeDir = $hdbInstance->get_instanceExeDir();
	my $hostnameDirectory = $hdbInstance->get_hostNameDir();
	$ENV{PYTHONPATH} = $hanaExeDir;
	$ENV{SAP_RETRIEVAL_PATH} = $hostnameDirectory;
	$ENV{SECUDIR} = File::Spec->catfile($hostnameDirectory, 'sec');
	$ENV{DIR_EXECUTABLE} = $hanaExeDir;
	$ENV{LD_LIBRARY_PATH} = sprintf("%s:%s", $ENV{LD_LIBRARY_PATH}, $hanaExeDir);

	# set environment for common crypto library in advance
	# it's required for secure SQL connections
	require SDB::Install::Sql::SSLConnectProperties;
	my $sslConnectProperties = new SDB::Install::Sql::SSLConnectProperties ();
	my $sslEnv = $sslConnectProperties->getCCLEnvironment ($hdbInstance);
	if (defined $sslEnv){
		foreach my $varName (keys (%$sslEnv)){
			$ENV{$varName} = $sslEnv->{$varName};
		}
	}
}

1;
