package LCM::Fcgi::SLPP;

use strict;
use SDB::Web::REST qw(:http);
use LCM::Slpp::SlppAdapter;
use LCM::Slpp::SlppExecutionHandler;
use LCM::Slpp::ExecutionState qw(STATE_DIALOG STATE_RUNNING);
use SDB::Web::TRACE qw( TRACE_VAR_TO_FILE );
use LCM::Slpp::Serializer qw(serialize deserialize); 
use SDB::Web::FcgiDispatcher;

my $slppAdapter = LCM::Slpp::SlppAdapter::getInstance();
my $executionHandler = LCM::Slpp::SlppExecutionHandler::getInstance();

get '/slp/metadata' => sub {
	my ($rest) = @_;
	my $structure = {
		metadata => {
			slppversion => '1.2.0',
		}
	};
	$rest->respond(200, serialize($structure));
};


get '/slp/config' => sub {
	my ($rest) = @_;
	TRACE_VAR_TO_FILE ('get_config', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, 'configAdapter', $slppAdapter);
	$rest->respond(200, serialize($slppAdapter->getParameters()));
};

get '/slp/pending_config' => sub {
	my ($rest) = @_;
	TRACE_VAR_TO_FILE ('get_pending_config', $SDB::Web::FcgiDispatcher::REQUEST_COUNT, 'configAdapter', $slppAdapter);
	my $pendingParametersCollection = $slppAdapter->getPendingParameters();

	if(defined($pendingParametersCollection)){
		$rest->respond(200, serialize($pendingParametersCollection));
	} else {
		$rest->respondText(404, "Resource not available");
	}
};

get '/slp/config/{id}' => sub {
	my ($rest) = @_;
	my $params = $rest->getPathParams();
	if ( defined $params && exists $params->{id} ) {
		my $slppParameter = $slppAdapter->getParameter($params->{id});
		
		if ($slppParameter) {
			$rest->respond(200, serialize($slppParameter));
		}	else {
			$rest->respondText(404, "Parameter is not available");
		} 
		return;
	}

	$rest->respondText(404, "Parameter is not available");
};

get '/slp/error' => sub {
	my ($rest) = @_;
	$rest->respond(200, serialize($slppAdapter->getSlppError()));
};

post '/slp/batchconfig' => sub {
	my ($rest) = @_;
	if ($executionHandler->getState() ne STATE_DIALOG) {
		$rest->respondText(403, "Process execution has already been started.");
		return;
	}
	my $value = '';
	eval('$value = deserialize($rest->getPostdata());');
	if ($@){
		$rest->respondText(415, "Unsupported Media Type");
		return;
	}

	$slppAdapter->updateParameters($value);
	my $action = $executionHandler->getAction('SUBMIT');
	if(defined $action) {
		my $executionStatus = $executionHandler->executeSlppAction($action);
		if ($executionHandler->getState() ne STATE_RUNNING) {
			$rest->respondText(400, 'The parameters provided are insufficient');
		} else {
			$rest->respondText(200, '');
		}
		return;
	}

	$rest->respondText(404, "SUBMIT is not available");
};

post '/slp/config' => sub {
	my ($rest) = @_;
	if ($executionHandler->getState() ne STATE_DIALOG) {
		$rest->respondText(403, "Process execution has already been started. Update of parameters is forbidden.");
		return;
	}
	my $value = '';
	eval('$value = deserialize($rest->getPostdata());');
	if ($@){
		$rest->respondText(415, "Unsupported Media Type");
		return;
	}
	$slppAdapter->updateParameters($value);
	$rest->respond(200, serialize($slppAdapter->getParameters()));
};

post '/slp/config/{id}' => sub {
	my ($rest) = @_;
	if ($executionHandler->getState() ne STATE_DIALOG) {
		$rest->respondText(403, "Process execution has already been started. Update of parameters is forbidden.");
		return;
	}
	my $value = '';
	eval('$value = deserialize($rest->getPostdata());');
	if ($@){
		$rest->respondText(415, "Unsupported Media Type");
		return;
	}
	my $params = $rest->getPathParams();
	if ( defined $params && exists $params->{id} ) {
		$slppAdapter->updateParameter($params->{id}, $value);

		my $parameter = $slppAdapter->getParameter($params->{id});
		
		if ( $parameter) {
			$rest->respond(200, serialize($parameter));
		} else {
			$rest->respondText( 404, "Parameter is not available");
		}
		return;
	}
	
	$rest->respondText(404, "Parameter is not available");
};

get '/slp/actions' => sub {
	my ($rest) = @_;
	my $applicableActions = $executionHandler->getSlppActions();
	$rest->respond(200, serialize($applicableActions));
};

get '/slp/actions/{id}' => sub {
	my ($rest) = @_;
	my $params = $rest->getPathParams();
	my $action = $executionHandler->getSlppAction($params->{id});
	
	if ( defined $action ) {
		$rest->respond(200, serialize($action));
		return;
	}

	$rest->respondText(404, "Action is not available");
};

post '/slp/actions/{id}' => sub {
	my ($rest) = @_;
	my $params = $rest->getPathParams();
	my $action = $executionHandler->getAction($params->{id});
	if(defined $action) {
		my $executionStatus = $executionHandler->executeSlppAction($action);
#		if ( !$executionStatus->isOK() ) {
#			$rest->respondText( 200, ${$executionStatus->getMessage()});
#			return;
#		}	
		$rest->respondText(200, '');
		return;
	}
	$rest->respondText(404, "Action is not available");
};

get '/slp/tasklist' => sub {
	my ($rest) = @_;
	$rest->respond(200, serialize($slppAdapter->getSlppTasklist()));
};

get '/slp/tasklist/{id}' => sub {
	my $rest = shift();
	my $task = $slppAdapter->getSlppTask();
	my $params = $rest->getPathParams();
	if($params->{id} eq $task->{Task}->{id}){
		$rest->respond(200, serialize($task));
	}
	$rest->respondText(404, "Task is not available");
};

get '/slp/monitor' => sub {
	my $rest = shift();
	$rest->respond(200, serialize($slppAdapter->getSlppMonitor()));
};

get '/slp/monitor/{id}' => sub {
	my $rest = shift();
	my $task = $slppAdapter->getSlppTask();
	my $params = $rest->getPathParams();
	if($params->{id} eq $task->{Task}->{id}){
		$rest->respond(200, serialize($task));
	}
	$rest->respondText(404, "Task is not available");
};

get '/slp/logs' => sub {
	my $rest = shift();
	my $logs = $slppAdapter->getLogs();
	$rest->respond(200, serialize($logs));
};

get '/slp/logs/{id}' => sub {
	my $rest = shift();
	my $params = $rest->getPathParams();
	my $logElement = $slppAdapter->getLogElementById($params->{id});
	if(defined($logElement)){
		$rest->respond(200, serialize($logElement));
	}
	$rest->respondText(404, "Log is not available");
};

1;
