package LCM::FeatureManager::CockpitFeatureManager;

use strict;
use warnings;
use parent 'LCM::FeatureManager::GenericFeatureManager';
use LCM::FeatureManager::Feature;
use LCM::FeatureManager::GenericFeatureManager qw(OPTIMIZED_INSTALL SECURE_STORE UDS_COMMUNICATION VOLUME_ENCRYPTION);
use SDB::Install::Globals qw($gKeynameEngine);


sub new {
    my $self = shift->SUPER::new(@_);
    my $sourceSeverVersion = $self->_getInstalledServerVersion();
    my $targetServerVersion = $self->_getInstallableServerVersion();
    $self->addFeature(LCM::FeatureManager::Feature->new(OPTIMIZED_INSTALL,  ['2','00','040'], undef, $targetServerVersion));
    $self->addFeature(LCM::FeatureManager::Feature->new(SECURE_STORE,       ['2','00','040'], undef, $targetServerVersion));
    $self->addFeature(LCM::FeatureManager::Feature->new(UDS_COMMUNICATION,  ['2','00','030'], undef, $sourceSeverVersion));
    $self->addFeature(LCM::FeatureManager::Feature->new(VOLUME_ENCRYPTION,  ['2','00','050'], undef, $targetServerVersion));
    return $self;
}

sub _getInstalledServerVersion {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    return $self->_getServerVersion($config->getSystemComponentManager());
}

sub _getInstallableServerVersion {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    return $self->_getServerVersion($config->getComponentManager());
}

sub _getServerVersion {
    my ($self, $componentManager) = @_;
    my $hdbComponent = $componentManager ? $componentManager->getComponentByKeyName($gKeynameEngine) : undef;
    return $hdbComponent ? $hdbComponent->getVersionObject() : undef;
}

1;