package LCM::Gui::App::LCMGuiAppExternall;
use strict;
use warnings;

use SDB::Install::Globals qw($gFlavourCockpit);
use LCM::Configuration::HdblcmExternalActionConfiguration;
use LCM::Configuration::ParametersCreator;
use base qw ( LCM::Gui::App::LCMGuiApp );

sub createActionConfiguration {
	my ( $self, ) = @_;
    return new LCM::Configuration::HdblcmExternalActionConfiguration( $self->{options}, $self->{configfile} );
}

sub createExecutor {
	my ($self, $action) = @_;
    if ($self->isHelp()) {
        require LCM::Task::HelpProcessTask;
        return LCM::Task::HelpProcessTask->new($self->getInstconfig(), $self);
    }
    return undef;
}

sub createConfiguration {
	my ($self, $action) = @_;

	my $config;
	my $actionConfig = $self->getActionConfiguration();
	require LCM::Configuration::GenericStackConfigurationFactory;
	# Bug: 237260 - if invalid batch values for component_dirs/root are passed via the {options} hash
	# from the App class to the new configuration, GenericParameter dialogs fail during their init()
	# because the config is in ErrorState. The ErrorState happens because setBatchValueOfRequiredParams()
	# during the init() calls setValue() for cmp_dirs/root with the invalid batch values inherited from the app.
	# This unset prevents that and is safe because we should only rely on the populated components in the MCM
	# which gets copied over from the actionConfig to the real config.
	$self->unsetComponentLocationOptions();
	if ( 'install' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createInstallConfiguration($self);
	} elsif ( 'update' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateConfiguration($self);
	}
	if (defined $config) {
		my $mcm = $actionConfig->getComponentManager()->clone($config);
        $config->setComponentManager($mcm);
	}
# Added because of TIPHANA15IT10-2040
# a 'kit' property is needed in the CollectOtherHostInfos
# method in AnyConfig in case of non-resident hdblcm
	if (defined $actionConfig->{kit}) {
		$config->{kit} = $actionConfig->{kit};
	}
	return $config;
}

sub getFlavour {
    my ($self) = @_;
    return $self->getActionConfiguration()->getFlavour();
}

sub isResident {
    return 0;
}

sub unsetComponentLocationOptions {
	my ($self) = @_;
	my $componentRootOpt = GetParamComponentFsRoot()->{opt};
	my $componentDirsOpt = GetParamComponentDirs()->{opt};
	undef $self->{options}->{$_} foreach ($componentRootOpt, $componentDirsOpt);
}

1;
