package LCM::Gui::Controllers::ControllersFactory;

use strict;
use parent qw(Exporter);
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::Configuration::GenericStackAny qw(INSTALL_ACTION UPDATE_ACTION UPDATE_COMPONENTS_ACTION);
use SDB::Install::Globals qw($gFlavourCockpit);
use LCM::Gui::Dialogs::Cockpit::CockpitStackController;

my $SIMPLE_UI_PARAM_ID = 'UseSimpleUI';
our @EXPORT = qw(CreateControllerForScenario);

sub CreateControllerForScenario {
    my ($scenario, $configuration, $wizard) = @_;
    my $isUsingSimpleMode = !$configuration->isSkipped($SIMPLE_UI_PARAM_ID) && $configuration->getBatchValue($SIMPLE_UI_PARAM_ID) =~ /$bool_true_pattern/;

    if ($scenario eq INSTALL_ACTION && $isUsingSimpleMode) {
        require LCM::Gui::Controllers::SimpleInstallController;
        return new LCM::Gui::Controllers::SimpleInstallController($configuration, $wizard);
    } elsif ($scenario eq INSTALL_ACTION) {
        require LCM::Gui::Controllers::InstallController;
        return new LCM::Gui::Controllers::InstallController($configuration, $wizard);
    } elsif ($scenario eq UPDATE_ACTION || $scenario eq UPDATE_COMPONENTS_ACTION) {
        my $app = Wx::wxTheApp();
        my $flavour = $app->getFlavour(1);
        if($flavour eq $gFlavourCockpit && $configuration->isCockpitOnPlatformAction()){
            return LCM::Gui::Dialogs::Cockpit::CockpitStackController->new($configuration, $wizard);
        } else {
            require LCM::Gui::Controllers::UpdateController;
            return new LCM::Gui::Controllers::UpdateController($configuration, $wizard);
        }
    }
    return undef;
}

1;
