package LCM::Gui::Controllers::SimpleInstallController;

use strict;
use LCM::Gui::PagePredicates qw(ShouldSkipMasterPassword);
use LCM::Gui::Dialogs::MasterPasswordDialog;
use parent 'LCM::Gui::Controllers::Controller';
use LCM::Gui::Dialogs::Install::ExpressSystemPropertiesDialog;

sub getCondensedSteps {
    my $self = shift();
    my $wizard = $self->getWizard();

    return [
        new LCM::Gui::Dialogs::Install::ExpressSystemPropertiesDialog($wizard),
        new LCM::Gui::Dialogs::MasterPasswordDialog($wizard),
    ];
}

sub getMapDialogIdToSkipPredicates {
    return {
        'SelectComponents' => sub { 1 },
        'MasterPasswordProperties' => sub { ShouldSkipMasterPassword() },
    };
}

1;