package LCM::Gui::Dialogs::AddHostRoles::AdditionalRolesDialog;

use strict;
use parent qw(LCM::Gui::Dialogs::AdditionalRolesDialog);

use SDB::Install::Globals qw ( GetAllRoles );
use LCM::App::AddHostRolesUtils qw(getPossibleRolesForExistingHosts);
use experimental qw (smartmatch);


sub handleRolesAccessability {
    my ($self, $hostObj) = @_;
    my $config = LCM::Gui::DialogUtilities::GetAppConfig();
    my @allValidRoles = @{GetAllRoles()};
    my $mHostToValidAdditionalRoles = getPossibleRolesForExistingHosts($config);
    my $aValidAdditionalRoles = $mHostToValidAdditionalRoles->{$hostObj->getHost()};
    for my $validRole (@allValidRoles) {
        my $isValidAdditionalRole = ($validRole ~~ @$aValidAdditionalRoles) ? 1 : 0;
        if (!$isValidAdditionalRole) {
            $self->{"role_$validRole"}->Enable(0);
        } else {
            $self->{"role_$validRole"}->Enable(1);
        }
    }
}

sub getRelevantRoles {
    my ($self) = @_;
    my $config = LCM::Gui::DialogUtilities::GetAppConfig();
    my $validRoles = getPossibleRolesForExistingHosts($config)->{$self->getHost()};
# Filter out the already existing roles. Otherwise the validation on the OK button will blow
# up in the add_roles case
    return [ grep { $_ ~~ @{$validRoles} } @{$self->getSelectedRoles()} ];
}

sub getValidationParamID {
    return 'AddRoles';
}

1;