#!/usr/bin/perl
package LCM::Gui::Dialogs::AddHosts::AddHostsProgressHandler;

use SDB::Install::Gui::Dialogs::Install;
use SDB::Common::Utils qw ( trim );

our @ISA = ( 'SDB::Install::Gui::Dialogs::PackageProgressHandler' );

use strict;

sub new {
    my $self = shift->SUPER::new (@_);
    $self->{label} = $_[1];
    $self->{id} = 'addHostPH';
    $self->{value} = 0;
    return $self;
}

sub addLine{
    my ($self, $text) = @_;
    $self->{label}->SetLabel (trim($text));
    unless ($text =~ /Starting\s(\d|on)|Stopping\s(\d|on)/) {
        $self->SetProgress ($text);
    }
}

sub StepFinished{
    my ($self,$error,$progress) = @_;
    
    $self->{value} = 0;
    if ($error){
        if(defined $progress)
        {
            $self->{'plan'}->SetProgress ($progress);
        }
        $self->addLine($error);
        $self->{'plan'}->Next('FINISHED_ERROR');
    }
    else{
        $self->{'plan'}->SetProgress (100);
        $self->{'plan'}->Next ('FINISHED_SUCCESS');
        $self->addLine("");
    }
}

sub SetProgress ($$) {
    my ($self) = @_;    
    $self->{value} += 3;
    if($self->{value} > 95) {
        $self->{value} = 95;
    }

    $self->{plan}->SetProgress($self->{value});
    Wx::Yield ();   
}

1;
