package LCM::Gui::Dialogs::AdditionalHostPropsDialog;

use Wx qw (wxVERTICAL wxALL wxEXPAND wxTE_PASSWORD wxALIGN_CENTER_VERTICAL wxOK wxCANCEL wxHORIZONTAL wxDefaultPosition wxDefaultSize
		wxCB_READONLY wxID_OK wxTAB_TRAVERSAL);
use Wx::Event qw (EVT_CHECKBOX EVT_TEXT EVT_COMBOBOX);

use strict;
use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);
use SDB::Install::Configuration::AnyMultiHostConfig qw($validHostRoles getSortedHostRoleNames);
use SDB::Install::Globals qw (getHumanReadableRoleByHostRole getHostRoleByHumanReadableRole);
use LCM::AdditionalHostHelper;

our @ISA = qw (Wx::Dialog);

sub new {
	my ($class, $parent) = @_;
	my ($self) = $class->SUPER::new($parent, -1, "Enter Host Parameters", wxDefaultPosition, new Wx::Size(450,280));

	$self->SetWindowStyleFlag($self->GetWindowStyleFlag | wxTAB_TRAVERSAL);
	$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	
	my $outer_sizer = new Wx::BoxSizer(wxVERTICAL);
	$self->SetSizer($outer_sizer);
	
	my $sizer = new Wx::BoxSizer(wxVERTICAL);
	$outer_sizer->Add($sizer, 1, wxALL | wxEXPAND, 20);
	$self->{"inner_sizer"} = $sizer;
	
	my $inputFormSizer = $self->CreateInputFormSizer();
	$sizer->Add($inputFormSizer, 1, wxEXPAND);
	
	$self->CreateControlActions();
	
	my $buttonsSizer = $self->CreateButtonSizer(wxOK | wxCANCEL);
	$sizer->Add($buttonsSizer, 0, wxEXPAND);
	
	$self->_getOKButton()->Enable(0);
		
	return $self;
}

sub CreateInputFormSizer {
	my ($self, $showSidAdmPasswordInputField) = @_;
	
	my $sizer = new Wx::FlexGridSizer( 5, 2, 5, 10 );
	$sizer->SetFlexibleDirection(wxHORIZONTAL);
	$sizer->AddGrowableCol(1);
	
	my $hostLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "Hostname", 1);
   	$sizer->Add($hostLbl, 0, wxALIGN_CENTER_VERTICAL);

	$self->{Hostname} = new Wx::TextCtrl($self, -1, "");
	$self->{Hostname}->SetFocus();
	$sizer->Add($self->{Hostname}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
	if ($showSidAdmPasswordInputField){
		_addSystemAdministratorPassword($self, $sizer);
	}

	my $roleLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "Role", 1);
   	$sizer->Add($roleLbl, 0, wxALIGN_CENTER_VERTICAL);
    my @validRoles = ();
    foreach my $currRole (@{getSortedHostRoleNames()}) {
		push(@validRoles, getHumanReadableRoleByHostRole($currRole));
    }

	$self->{Role} = new Wx::ComboBox($self, -1, "", wxDefaultPosition, wxDefaultSize, \@validRoles, wxCB_READONLY);
	$self->{Role}->Select(0);
	$sizer->Add($self->{Role}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
	my $haGroupLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "High-Availability Group", 0);
   	$sizer->Add($haGroupLbl, 0, wxALIGN_CENTER_VERTICAL);

	$self->{HostGroup} = new Wx::TextCtrl($self, -1, "default");
	$sizer->Add($self->{HostGroup}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);

	my $workerGroupLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "Worker Group", 0);
	$sizer->Add ($workerGroupLbl, 0, wxALIGN_CENTER_VERTICAL);

	$self->{WorkerGroup} = new Wx::TextCtrl($self, -1, "default");
	$self->{WorkerGroupLabel} = $workerGroupLbl;
	$sizer->Add ($self->{WorkerGroup}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);

	$sizer->AddSpacer (1);
	my $defineSPManually = new Wx::CheckBox($self, -1, "Define Storage Partition Manually");
	$self->{defineSPManually} = $defineSPManually;	
	$sizer->Add($defineSPManually, 0, wxALIGN_CENTER_VERTICAL );
	
	my $spLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "Storage Partition", 0);
   	$sizer->Add($spLbl, 0, wxALIGN_CENTER_VERTICAL);

	$self->{StoragePartition} = new Wx::TextCtrl($self, -1, $LCM::AdditionalHostHelper::SP_AUTO_ASSIGN);
	$self->{StoragePartition}->Enable(0);
	$sizer->Add($self->{StoragePartition}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
	
	return $sizer;
}

sub _addSystemAdministratorPassword {
	my ($self, $sizer) = @_;

    my $instconfig = Wx::wxTheApp()->{instconfig};
    my $action = $instconfig->getAction();
	if( $action eq 'install'){
		return;
	}

	my $sid = (defined $instconfig->getValue('SID')) ?
				$instconfig->getValue('SID') : $instconfig->getDefault('SID');
	my $sidAdm = $instconfig->getSysAdminUserName($sid);
	my $sidAdmPasswordLbl = SDB::Install::Gui::Control::Label->new( $self, -1, "System Administrator '$sidAdm' Password", 1);
    $sizer->Add($sidAdmPasswordLbl, 0, wxALIGN_CENTER_VERTICAL);

    $self->{Password} = new Wx::TextCtrl($self, -1, "", wxDefaultPosition, [200, -1], wxTE_PASSWORD);
    $sizer->Add($self->{Password}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
}

sub CreateControlActions {
	my ($self, ) = @_;
	
	EVT_CHECKBOX($self, $self->{defineSPManually}->GetId(), \&_onChkBoxDefineSPManually);
    EVT_TEXT($self, $self->{Hostname}->GetId(), \&_updateButtonsState);
    EVT_TEXT($self, $self->{StoragePartition}->GetId(), \&_updateButtonsState);
    EVT_COMBOBOX($self, $self->{Role}->GetId(), \&_onCbRoleChanged);
}

sub _onCbRoleChanged {
	my ($self) = @_;
	my $humanReadableRole = $self->{Role}->GetValue();
	my $role = getHostRoleByHumanReadableRole($humanReadableRole);
	my $instconfig = Wx::wxTheApp()->{instconfig};

	if (LCM::AdditionalHostHelper::shouldDisplayAutoAssign($humanReadableRole)) {
		$self->{defineSPManually}->Enable(1);
	} else {
		$self->{defineSPManually}->SetValue(0);
		$self->{defineSPManually}->Enable(0);
	}
	if($self->_shouldDisplayWorkerGroup($role)){
		$self->{WorkerGroup}->Enable(1);
		$self->{WorkerGroupLabel}->Enable(1);
	} else {
		my $defaultWorkerGroup = $instconfig->getDefault('WorkerGroup');
		$self->{WorkerGroup}->SetValue($defaultWorkerGroup);
		$self->{WorkerGroup}->Enable(0);
		$self->{WorkerGroupLabel}->Enable(0);
	}
	my $group = $self->_getDefaultGroupValueAccordingToRole($role);
	$self->{HostGroup}->SetValue($group);
	$self->_onChkBoxDefineSPManually();
}

sub _shouldDisplayWorkerGroup {
    my ($self, $role) = @_;
    return exists($validHostRoles->{$role}) && $validHostRoles->{$role}->{hasWorkerGroup};
}

sub _getDefaultGroupValueAccordingToRole {
	my ($self, $role) = @_;
	
	if(exists($validHostRoles->{$role})){
		return $validHostRoles->{$role}->{defaultGroup};
	}
	return 'default';
}

sub _onChkBoxDefineSPManually {
	my ($self) = @_;
	my $isChecked = $self->{defineSPManually}->IsChecked();
	my $isEnabled = $self->{defineSPManually}->IsEnabled();
	
	$self->{StoragePartition}->Enable($isChecked);
	$self->{StoragePartition}->SetValue($isEnabled ? ($isChecked ? "" : $LCM::AdditionalHostHelper::SP_AUTO_ASSIGN) : $LCM::AdditionalHostHelper::SP_NA);
	$self->_updateButtonsState();
}

sub _updateButtonsState {
	my ($self) = @_;
	my $okState = 1;
	if (!$self->{Hostname}->GetValue()) {
		$okState = 0;
	}
	
	if ($okState and $_[0]->{defineSPManually}->IsChecked() and !$self->{StoragePartition}->GetValue()) {
		$okState = 0;
	}
	
	$self->_getOKButton()->Enable($okState);
}

sub _getOKButton {
	my ($self) = @_;
	
	my $okBtn = Wx::Window::FindWindowById(wxID_OK, $self);
	return $okBtn;
}

sub GetHost() {
	my ($self) = @_;
	
	my $role = getHostRoleByHumanReadableRole($self->{Role}->GetValue());
	my @roles = ($role);
	for (@{$self->{roles}}) {
		push @roles, $_ if $_ ne $role;
	}
	my @hostRole = map{$_} @roles;
	my $host = {
		host => $self->{Hostname}->GetValue(),
		role => join(',', @hostRole),
		group => $self->{HostGroup}->GetValue(),
		workergroup => $self->{WorkerGroup}->GetValue(),
		storage_partition => $self->{defineSPManually}->IsChecked() ? $self->{StoragePartition}->GetValue() : undef
	};
	return new LCM::AdditionalHostHelper($host);
}

sub SetHost() {
	my ($self, $host) = @_;
	
	$self->{Hostname}->SetValue($host->getHost());

	my $cbIndex = 0;
	my @roles = split(',', $host->getRole());
	my $role = shift @roles;
	$self->{roles} = \@{roles};
	$self->{Role}->SetValue($role);
	foreach my $currRole (@{getSortedHostRoleNames()}) {
		last if($currRole eq $role);
		$cbIndex += 1;
    }
	$self->{Role}->Select($cbIndex);
    
	$self->_onCbRoleChanged ();
	$self->{HostGroup}->SetValue($host->getGroup()) if defined $host->getGroup();
	$self->{WorkerGroup}->SetValue($host->getWorkerGroups()) if defined $host->getWorkerGroups();
	if (defined $host->getStoragePartition()) {
		$self->{defineSPManually}->SetValue(1);
		$self->{StoragePartition}->Enable(1);
		$self->{StoragePartition}->SetValue($host->getStoragePartition());
	}	
	$self->_updateButtonsState ();
}

1;
