package LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog;

use strict;
use Wx qw(wxALIGN_LEFT wxALIGN_CENTER_VERTICAL);
use Wx::Event qw (EVT_HYPERLINK);
use parent qw(LCM::Gui::Dialogs::FinalizeDialog);
use LCM::App::AbstractApplication qw(openURL);

my $launchCockpitMessage = 'Launch the SAP HANA cockpit by opening ';
my $launchCockpitManagerMessage = 'Launch the SAP HANA cockpit manager by opening ';

sub _createTitleArea{
    my ( $self, $config ) = @_;
    $self->SUPER::_createTitleArea( $config );

    my $app               = Wx::wxTheApp();
    my $executor          = $app->getExecutor();
    my $instconfig        = $app->getInstconfig();
    my $parent_sizer      = $self->{"inner_sizer"};
    my $hostname          = $instconfig->getValue('HostName');

    if( defined $executor && $executor->getStatus()->isInFinishedState() ) {
        my $cockpitConfigurationUtilityUrl = $instconfig->{'cockpit-admin-web-app'};
        my $cockpitMonitoringConsoleUrl    = $instconfig->{'cockpit-web-app'};

        my $counter = (defined $cockpitConfigurationUtilityUrl) + (defined $cockpitMonitoringConsoleUrl);
        return undef if ! $counter;

        my $sizer = new Wx::FlexGridSizer( $counter, 2);
        $parent_sizer->Add($sizer, 0, wxALIGN_LEFT);

        if(defined $cockpitMonitoringConsoleUrl) {
            my $monitorLabel = new Wx::StaticText($self, -1, $launchCockpitMessage);
            my $monitorLink = new Wx::HyperlinkCtrl($self, -1, $cockpitMonitoringConsoleUrl, $cockpitMonitoringConsoleUrl);
            EVT_HYPERLINK($self, $monitorLink->GetId(), sub {
                openURL($cockpitMonitoringConsoleUrl, 1); # force open
            });
            $sizer->Add($monitorLabel,0, wxALIGN_CENTER_VERTICAL );
            $sizer->Add($monitorLink,0, wxALIGN_CENTER_VERTICAL );
        }

        if(defined $cockpitConfigurationUtilityUrl) {
            my $configLabel = new Wx::StaticText($self, -1, $launchCockpitManagerMessage);
            my $configLink = new Wx::HyperlinkCtrl($self, -1, $cockpitConfigurationUtilityUrl, $cockpitConfigurationUtilityUrl);
            EVT_HYPERLINK($self, $configLink->GetId(), sub {
                openURL($cockpitConfigurationUtilityUrl, 1); # force open
            });
            $sizer->Add($configLabel,0, wxALIGN_CENTER_VERTICAL );
            $sizer->Add($configLink,0, wxALIGN_CENTER_VERTICAL );
        }

        $parent_sizer->AddSpacer(20);

        $self->_addLaunchMessagesToLog();
    }
}

sub _addLaunchMessagesToLog {
    my $self = shift;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    my $cockpitManagerMsg = "\n".$launchCockpitManagerMessage.$instconfig->{'cockpit-admin-web-app'};
    my $cockpitUrlMsg = "\n".$launchCockpitMessage.$instconfig->{'cockpit-web-app'};

    $app->getMsgLst()->addMessage("\n$cockpitUrlMsg$cockpitManagerMsg");
}

1;
