#!/usr/bin/perl

package LCM::Gui::Dialogs::HostagentPasswordDialog;

use Wx qw ( wxCENTRE wxVERTICAL wxEXPAND wxLEFT wxALL wxICON_EXCLAMATION wxOK );
                    
use SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Gui::Design;
use SDB::Install::Gui::Control::Label;
use strict;
use LCM::Gui::Dialogs::UiComponentsFactory;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

sub new{
	my($self ) = shift->SUPER::new(@_);
    
    my $sapadm = Wx::wxTheApp->{instconfig}->{username};
    $self->{id} = 'SHAPassword';
    $self->{label_text} = 'Specify the Properties of the SAP Host Agent User';
    $self->{name} = 'Define SAP Host Agent User';
    
    return $self;
}


sub init(){
	my ($self,$config) = @_;
	
	my $is_gtk1 =  Wx::wxGTK1();
	my $app = Wx::wxTheApp;
	my ($instconfig, $kit) = ($app->{instconfig}, $app->{kit}, );

	my $sizer = Wx::BoxSizer->new(wxVERTICAL);
	$sizer->AddSpacer (16);

	$self->{'titel_big'} = CreateTitle($self, $self->{label_text}, $is_gtk1);
	$sizer->Add($self->{'titel_big'},0, wxLEFT , 16 );
	
	$sizer->AddSpacer (16);
	$self->{user_window} = new SAPDB::Install::Window::DBUserSimple ($self,-1);
	$self->{isConfirmPasswordNeeded} = $self->_isConfirmPasswordNeeded();
	$self->_addPageProperties($self->{isConfirmPasswordNeeded});
	$self->{user_window}->{ctrl_user}->Enable(0) if (!defined $self->_getHostagentUserNameParam());
	$self->{user_window}->{label_confirm_passwd}->Show(0) if !$self->{isConfirmPasswordNeeded};
	$self->{user_window}->{ctrl_confirm_passwd}->Show(0) if !$self->{isConfirmPasswordNeeded};
	$sizer->Add ($self->{user_window},-1, wxEXPAND | wxALL, 16);
	$self->SetSizerAndFit($sizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	
	$self->Show(1);
	
	if ($instconfig->ErrorState){
		$self->GetWizard ()->LayoutDlg ();
		Wx::MessageBox($instconfig->GetErrorString (), "Configuration Error",
			 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
	}

	return {}; 
}

sub _isConfirmPasswordNeeded{
	my $instconfig = Wx::wxTheApp()->{instconfig};
	if ($instconfig->isa('LCM::Configuration::RenameSystemConfiguration') ){
		return $instconfig->isHostagentPasswordInitial()? 1 :0 ;
	}
	return !($instconfig->isSkipped('InitialHostagentPassword') == 1);
}

sub _addPageProperties {
	my ($self, $addConfirmPassword) = @_;
	
	my $instconfig = Wx::wxTheApp->{instconfig};
	my $password = $instconfig->{params}->{HostagentPassword}->{value};
	my $sapadm = $self->_getHostagentUsername();
	
	
	if($addConfirmPassword) {
		$self->{user_window}->SetValue ({'Name' => $sapadm,
			(defined $password ? ('Password' , $password, 'ConfirmPassword', $password) : ())});
	} else {
		$self->{user_window}->SetValue ({'Name' => $sapadm,
			(defined $password ? ('Password' , $password) : ())});
	}
}

sub _getHostagentUsername {
	my ($self, )= @_;
	
	my $hostagent_username_param = $self->_getHostagentUserNameParam();
	if(!defined $hostagent_username_param) {
		return "sapadm";
	}
	
	return $hostagent_username_param->{value};
}

sub _getHostagentUserNameParam {
	my ($self, ) = @_;
	return Wx::wxTheApp->{instconfig}->{params}->{HostagentUserName};
}

sub Process{
	my ($self,$config) = @_;

	my $app = Wx::wxTheApp;
	my $instconfig = $app->{instconfig};
	$instconfig->ResetError();
	
	my $userWindow = $self->{user_window};
	my $user_values = $userWindow->GetValue();

	if ( defined $self->_getHostagentUserNameParam() ) {
		my $username = $user_values->{Name};
		if ( $username ne "sapadm" ) {
	        if ( ! $instconfig->setValue('HostagentUserName', $username) ) {
	            $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
	            $userWindow->{ctrl_passwd}->SetFocus();
	            return undef;
	        }			
		}
	}	
	
	my $password = $user_values->{Password};

	if ( $self->_isConfirmPasswordNeeded() ) {
		my $confirm_password =  $user_values->{ConfirmPassword};
		if ( $password ne $confirm_password ) {
			$app->ShowErrorMsg ("Password confirmation doesn't match");
			$userWindow->{ctrl_passwd}->SetFocus();
			return undef;
		}
	}
	
	
	if ( ! $instconfig->setValue('HostagentPassword',$password) ) {
		$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
		$userWindow->{ctrl_passwd}->SetFocus();
		return undef;
	}
	
	return {};
}


sub Back{
	$_[0]->Reset();
}	

sub Reset{
	my ($self) = @_;
    
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

	delete $self->{title_big};
	delete $self->{dynctrl};
	$self->SUPER::Reset();
}

	

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
