package LCM::Gui::Dialogs::InstallPanel;

use Wx qw ( wxVERTICAL wxALIGN_CENTER_VERTICAL wxEXPAND );

use LCM::Gui::DialogUtilities qw ( GetAppConfig );
use base (LCM::Gui::Dialogs::HostsPanel);

sub newFieldsSizer {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $sizer = undef;
    
    $sizer = $self->fieldsSizer($instconfig);
    $self->_addInstallationPaths( $sizer );
    
    return $sizer;
}

sub setFieldProperties {
# In remote_execution=ssh we do not need the hostagent's password here
    my ($self, $instconfig) = @_;
    my $isShaPasswordSkipped = $instconfig->isSkipped('HostagentPassword');

    $instconfig->setSkip('HostagentPassword', 1) if(! $instconfig->isUseSAPHostagent());

    $self->SUPER::setFieldProperties($instconfig);

    $instconfig->setSkip('HostagentPassword', $isShaPasswordSkipped);
}

sub _addInstallationPaths {
    my ( $self, $sizer ) = @_;

    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    my $window = $self->getWindow();
    my $targetParam = $instconfig->{params}->{'Target'};
    my $label = new SDB::Install::Gui::Control::Label( $window, -1, $targetParam->{str}, $targetParam->{mandatory});
    $self->addWindowControl( 'TargetLabel', $label);
    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
    $self->addWindowControl( 'Target', new SAPDB::Install::Control::PathCtrl ($window, 1, $instconfig->getDefault('Target') ? $instconfig->getDefault('Target') : "") );
    $sizer->Add( $window->{Controls}->{'Target'} , 1, wxALIGN_CENTER_VERTICAL | wxEXPAND );

    my $checkmntParam = $instconfig->{params}->{'CheckMnt'};
    $label = new SDB::Install::Gui::Control::Label( $window, -1, $checkmntParam->{str}, $checkmntParam->{mandatory});
    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
    $self->addWindowControl( 'CheckMnt', new SAPDB::Install::Control::PathCtrl ($window, 1, $instconfig->getDefault('CheckMnt') ? $instconfig->getDefault('CheckMnt') : "" ) );
    $sizer->Add( $window->{Controls}->{'CheckMnt'}, 1, wxALIGN_CENTER_VERTICAL | wxEXPAND);
}

sub newAddHostsSizer {
    my ( $self) = @_;
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
     my $window = $self->getWindow();
    my $label = new SDB::Install::Gui::Control::Label( $window, -1, "Additional hosts", 0);
    $sizer->Add($label, 0, wxALIGN_CENTER_VERTICAL );
    
    $self->addHostsPanel( $sizer);
    return $sizer;
}
1;