package LCM::Gui::Dialogs::InternalNetworkPropertiesDialog;

use base qw(SDB::Install::Gui::Dialogs::GenericParameter);

use Wx::Event qw (EVT_COMBOBOX);
use strict;

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = 'InterServiceCommunicationProperties';
    $self->{label_text} = 'Enter Inter-Service Communication Properties';
    $self->{name} = 'Enter Inter-Service Communication Properties';

    return $self;
}

sub init {
	my ($self) = @_;

	if (not defined $self->{initialized}) {
		my $config = Wx::wxTheApp()->getInstconfig();
		$self->_callBaseInit();
		$self->_createControlBinding();
		$self->{initialized} = 1;
	}

	$self->Layout();
	return {};
}

sub _callBaseInit {
	my $self = shift();
	my $config = Wx::wxTheApp()->getInstconfig();
	# prevent showing asteriks for mandatory parameter on Internal Network Parameter
	my $oldMandatoryValue = $config->{params}->{InternalNetwork}->{mandatory};
	my $oldSkipValue = $config->{params}->{InternalNetwork}->{skip};
	$config->setSkip('InternalNetwork', 0);
	$config->{params}->{InternalNetwork}->{mandatory} = 0;
	$self->SUPER::init($config);
	$config->{params}->{InternalNetwork}->{mandatory} = $oldMandatoryValue;
	$config->setSkip('InternalNetwork', $oldSkipValue);
}

sub _createControlBinding{
	my ($self) = @_;

	$self->handleInternalNetworkControlState();

	EVT_COMBOBOX($self->{dynctrl}->{ListenInterface_ctrl}, -1, sub {
		$self->handleInternalNetworkControlState();
	});
}

sub handleInternalNetworkControlState{
	my ($self) = @_;
	my $listenInterfaceCtrl = $self->getParamCtrl('ListenInterface');
	my $internalAddressLbl = $self->getParamLabel('InternalNetwork');
	my $internalAddressCtrl = $self->getParamCtrl('InternalNetwork');
	my $internalAddressRecommendationText = $self->getParamRecommendationText('InternalNetwork');
	my $config = Wx::wxTheApp()->getInstconfig();

	for my $validValue (@{$config->{params}->{ListenInterface}->{valid_values}}) {
		if($listenInterfaceCtrl->GetValue() =~ $validValue) {
			$config->setValue('ListenInterface', $validValue);
			last;
		}
	}

	my $validNetworkValues = $config->{params}->{InternalNetwork}->{valid_values};
	my $hasValidValues = (defined $validNetworkValues && scalar(@$validNetworkValues));
	my $defaultSelectionIndex = 0;

	if ($hasValidValues && index ($listenInterfaceCtrl->GetValue(), 'local') == -1 ) {
        my $defaultNetworkValue = $config->getDefault('InternalNetwork');
        if (defined $defaultNetworkValue) {
            my ($defaultNetworkValueIndex) = grep { $validNetworkValues->[$_] eq $defaultNetworkValue} 0..@{$validNetworkValues};
            $defaultSelectionIndex = $defaultNetworkValueIndex;
        }
		$internalAddressCtrl->SetItems($validNetworkValues);
		$internalAddressLbl->Show();
		$internalAddressCtrl->Show();
# set the first valid value in order to clear old one that might not be applicable for the currently selected ListenInterface
		$internalAddressCtrl->SetSelection($defaultSelectionIndex);
		$internalAddressRecommendationText->Show() if(defined($internalAddressRecommendationText));
	} else {
		$internalAddressLbl->Hide();
		$internalAddressCtrl->Hide();
		$internalAddressRecommendationText->Hide() if(defined($internalAddressRecommendationText));
	}
	$self->Layout();
}

sub getParamKeys{
    my ($self) = @_;
    my $config = Wx::wxTheApp()->getInstconfig();
    my $paramKeys = ['ListenInterface', 'InternalNetwork'];
    return $paramKeys;
}

1;