#!perl 
#===============================================================================
#
# Copyright (C) 2000 - 2014 by SAP AG,  http://www.sap.com.
# All rights reserved.
#
# This software is the confidential and proprietary information of SAP AG.
# You shall not disclose such confidential information and shall use it only
# in accordance with the terms of the license agreement you entered into with SAP.
#
#       AUTHOR: i072928
#

=head1 NAME

StoragePropertiesDialog

=head1 DESCRIPTION

Storage parameters for the system rename scenario.
=cut

#===============================================================================
package LCM::Gui::Dialogs::Rename::StoragePropertiesDialog;

use strict;
our @ISA = qw (SDB::Install::Gui::Dialogs::GenericParameter);
use Wx qw ( wxEXPAND wxHORIZONTAL wxLEFT wxTOP wxALIGN_CENTER );
use LCM::Gui::Dialogs::UiComponentsFactory;
use SAPDB::Install::Resources;

our $is_gtk1 = 0;    #Wx::wxGTK1 ();
our $resources = new SAPDB::Install::Resources();
our $images    = $resources->getImages(qw(icon/warning.png));

sub new {
	my ( $self ) = shift->SUPER::new ( @_ );

	$self->{id}         = 'StoragePropertiesDialog';
	$self->{label_text} = "Storage Properties Configuration";
	$self->{name}       = 'Define Storage Properties';
	
	my $instconfig = Wx::wxTheApp->{instconfig};

	return $self;
}

#Override
sub AddAdditionalParams {
    my ( $self, $instconfig ) = @_;

    my $param = $instconfig->{params}->{BasePathDataVolumes};
    if ($param->{skip} || ((defined $param->{set_interactive}) && !$param->{set_interactive})){
        $self->{'warnings_icon'} = Wx::StaticBitmap->new( $self, -1, new Wx::Bitmap( $images->{'icon/warning.png'} ) );
        $self->{'warnings_text'} = CreateTitle($self, "", $is_gtk1 );
        $self->{'warnings_icon'}->Show(1);
        $self->{'warnings_text'}->Show(1);        
        $self->{'warnings_text'}->SetLabel( "Base data and log volumes paths will be set automatically." );
                          
        my $warning_sizer = new Wx::BoxSizer(wxHORIZONTAL);
        $warning_sizer->Add($self->{'warnings_icon'}, 0, wxLEFT | wxTOP, 20);
        $warning_sizer->AddSpacer(10);
        $warning_sizer->Add($self->{'warnings_text'}, 0, wxEXPAND | wxTOP | wxALIGN_CENTER, 20);
    
        $self->{main_sizer}->Add ($warning_sizer, 1, wxLEFT);
    }
    return 1;   
}

sub getParamKeys {
	my ( $self ) = @_;
	my @paramKeys;

	push( @paramKeys, 'BasePathDataVolumes' );
	push( @paramKeys, 'BasePathLogVolumes' );
	push( @paramKeys, 'BasePathDataBackup' );
	push( @paramKeys, 'BasePathLogBackup' );
	push( @paramKeys, 'BasePathCatalogBackup' );

	return \@paramKeys;
}

sub Process {
    my ( $self, $config ) = @_;
    my $rc = $self->SUPER::Process ( $config );
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};

    my $wizard = $self->GetWizard ();
    my $shouldSkipDbCredentialsPage = $instconfig->isSkipped('ChangeSystemPasswd') ? 1 : 0;
	$wizard->SkipDialog ('HDBUserPropertiesDialog', $shouldSkipDbCredentialsPage); 

    return $rc;
}

1;
