package LCM::Gui::Dialogs::ResumePendingInstallPropertiesDialog;

use strict;

use base qw (SDB::Install::Gui::Dialogs::GenericParameter);
use Wx qw ( wxCENTRE wxICON_EXCLAMATION wxOK wxTE_PASSWORD wxALIGN_CENTER_VERTICAL wxEXPAND );
use LCM::Gui::DialogUtilities qw ( GetAppConfig );
our $ID = 'ResumePendingInstallDialog';

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = $ID;
    $self->{label_text} = "Enter Pending Install Properties";
    $self->{name} = "Define Pending Install Properties";

    return $self;
}

sub init {
	my $self = shift;
	my $initializationState = $self->SUPER::init(@_);
	if(defined($initializationState) && $initializationState->{errstate} == 1) {
		Wx::PostEvent ($self->GetWizard(), $self->GetWizard()->{'pbutton_event'});
		return;
	}
	return $initializationState;
}

sub getParamKeys{
	my ($self, $configuration) = @_;

	my @parametersIds = @{$configuration->getParamIds()};
	my @filteredParamIds = ();
	my $persistenceData = $configuration->pers_load();

	$configuration->setBatchValueOfRequiredParams('UseMasterPassword');
	for my $parameterId (@parametersIds) {
		next if $configuration->isSkipped($parameterId);
		next if $configuration->isHidden($parameterId);
		next if defined $configuration->getValue( $parameterId );
		next if defined $persistenceData->{$parameterId}; 
		push @filteredParamIds, $parameterId;
	}
	return \@filteredParamIds;
}

1;
