package LCM::Gui::Dialogs::SelectActivityDialog;

use strict;

use Wx qw (wxVERTICAL wxLEFT wxBLACK wxDefaultPosition wxDefaultSize wxEXPAND wxALL wxLC_REPORT wxNO_BORDER wxLC_NO_HEADER);

use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw($isWin);

use base 'SAPDB::Install::Wizard::Dialog::Base';

sub _createDescriptionSizer{
	my ( $self ) = @_;
	my $is_gtk1 = Wx::wxGTK1 ();
	
	$self->{'description_box'} = Wx::StaticBox->new($self,-1,'System Description');
    $self->{'description_box'}->SetFont( SDBFONT_BoldText ) if (!$is_gtk1);
    $self->{'description_box'}->SetForegroundColour (wxBLACK);
    $self->{'description_box'}->Refresh (1);
    $self->{'description_box'}->Show(0);
	my $descriptionInnerSizer = Wx::StaticBoxSizer->new($self->{'description_box'},wxVERTICAL);	

	$self->{'description_list'} = Wx::ListCtrl->new( $self, -1, wxDefaultPosition, wxDefaultSize, wxLC_REPORT | wxLC_NO_HEADER | wxNO_BORDER);
	$self->{'description_list'}->InsertColumn( 1, "Parameter" );
	$self->{'description_list'}->InsertColumn( 2, "Value" );
	$self->{'description_list'}->Show(0);	
	
    $self->{'description_list'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
	$descriptionInnerSizer->Add($self->{'description_list'},1,wxEXPAND | wxALL ,20);
	my $descriptionOuterSizer = Wx::BoxSizer->new(wxVERTICAL);
    $descriptionOuterSizer->Add($descriptionInnerSizer,1,wxEXPAND | wxLEFT);
    
    return $descriptionOuterSizer;
}

sub getStringDescriptionItems{
    my $self = shift;
    return $self->{'description_items'};
}

sub addDescriptionStringItem{
    my ($self,$label,$info) = @_;
    $self->{'description_items'} = [] if(!defined $self->{'description_items'});
    my $descItem = {
        'label' => $label,
        'info' => $info
    };
    push(@{$self->{'description_items'}},$descItem);
}

sub getDescriptionStringItemLabel{
    my($self,$item) = @_;
    return $item->{'label'};
}

sub getDescriptionStringItemInfo{
    my($self,$item) = @_;
    return $item->{'info'};
}

sub clearDescriptionItems{
    my $self = shift;
    $self->{'description_items'} = [];
}
sub getSapSystem{
    ...
}

sub getSAPInstance{
    my($self) = @_;
    my $sapSystem = $self->getSapSystem();
    return undef if(!defined $sapSystem);
    my $instances = $sapSystem->getNewDBInstances ();
    my $instance;
    if (defined $instances && defined $instances->[0]){
        $instance = $instances->[0];
    }
    return $instance;
}

sub addInstallationPath{
    my $self = shift;
    my $sapSystem = $self->getSapSystem();
    return undef if(!defined $sapSystem);
    if ($isWin){
        $self->addDescriptionStringItem("Installation Path",$sapSystem->getUsrSapSid ());
    } else{
        my $instPath = $sapSystem->get_target() ? $sapSystem->get_target() : substr ($sapSystem->get_globalSidDir(), 0, -4);
        $self->addDescriptionStringItem("Installation Path",$instPath);
    }
}

sub addHosts{
    my ($self,$instance) = @_;
    my @hosts = @{$instance->getAllHostsWithRoles(1)};
    $self->addDescriptionStringItem("Hosts",shift @hosts);
    foreach my $host (@hosts){
        $self->addDescriptionStringItem("",$host);
    }
}

sub addPlugins{
    my ($self,$instance) = @_;
    my $pluginInstallations = $instance->getPluginInstallations();
    my @pluginKeys;
    my $plugins;
    if (defined $pluginInstallations && @$pluginInstallations){
        foreach my $inst (@$pluginInstallations){
            push @pluginKeys, $inst->getProductKey();
        }
        $plugins .= join(', ', @pluginKeys) if (@pluginKeys);
    }
    if ($plugins) {
        $self->addDescriptionStringItem("Plugins",$plugins);
    }
}

sub addInstanceNr{
    my $self = shift;
    my $instance = $self->getSAPInstance();
    return if(!defined $instance);
    $self->addDescriptionStringItem("Instance Number",$instance->get_nr());
}

sub compileDescriptionItems{
    my ($self) = @_;
    $self->clearDescriptionItems();
    $self->addSystemId();
    $self->addInstanceNr();
    $self->addVersion();
    $self->addInstallationPath();
    my $instance = $self->getSAPInstance();
    if(defined $instance){
        $self->addHosts($instance);
        $self->addPlugins($instance);
    }
    $self->addPendingInfo();
}

sub _fillSystemDescription {
    my ( $self ) = @_;
    $self->{'description_list'}->DeleteAllItems();
    my $count = 0 ;
    $self->compileDescriptionItems();
    foreach my $descriptionStringItem(@{$self->getStringDescriptionItems()}){
        my $itemIdx = $self->{'description_list'}->InsertStringItem($count,$self->getDescriptionStringItemLabel($descriptionStringItem));
        $self->{'description_list'}->SetItem($itemIdx,1,$self->getDescriptionStringItemInfo($descriptionStringItem));
        $count++;
    }
    $self->{'description_list'}->SetColumnWidth(0,-1);
    if ($^O =~ /mswin/i){
        $self->{'description_list'}->SetColumnWidth(1,-2);
    } else{
        $self->{'description_list'}->SetColumnWidth(1,-1);
    }
    $self->{description_list}->SetColumnWidth (0,$self->{description_list}->GetColumnWidth (0) + 20);
    $self->{description_box}->Show(1);
    $self->{description_list}->Show(1);
    $self->Layout ();
}

1;
