package LCM::Gui::Dialogs::SelectComponentsForResidentUpdateDialog;

use strict;

use LCM::Gui::Dialogs::UpgradeParameterDialog;
use LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog;
use LCM::Gui::Dialogs::StreamingPropertiesDialog;
use LCM::Gui::Dialogs::EsStoragePropertiesDialog;
use LCM::Gui::Dialogs::AcceleratorPropertiesDialog;
use LCM::Gui::Dialogs::XSPropertiesDialog;
use LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog;
use LCM::Gui::Dialogs::InternalNetworkPropertiesDialog;
use LCM::Gui::Dialogs::SelectXsComponentsDialog;
use SDB::Install::Gui::Design;
use LCM::Gui::PagePredicates qw(
								ShouldSkipUpgradeProperties
								ShouldSkipAdditionalHostsProperties
								ShouldSkipStreamingPropertiesPage
								ShouldSkipEsStoragePage
								ShouldSkipAcceleratorPropertiesPage
								ShouldSkipInternalNetworkPropertiesPage
								ShouldSkipXSPropertiesPage
								ShouldSkipXSSpaceIsolationPropertiesPage
								ShouldSkipSelectXSApplicationsPage
								ShouldSkipLSSPropertiesDialog);

use base qw (LCM::Gui::Dialogs::SelectComponentsForUpdateDialog);

sub _initializeCondensedSteps {}

sub _fillResidentCondensedSteps {
	my $self = shift;
	my $previousDialogId = $self->GetID ();
	my $wizard = $self->GetWizard ();
	my $controller = $wizard->getController();
	my $shouldSkipPredicates = $controller->getMapDialogIdToSkipPredicates();
	my @dialogs = grep { $_->GetID() ne 'CertificatesDialog' } @{$controller->getCondensedSteps()};
	
	foreach my $dialog (@dialogs){
		$wizard->InsertDialog ($dialog, $previousDialogId, 'input', $shouldSkipPredicates->{$dialog->GetID()});
		$previousDialogId = $dialog->GetID();	
	}
}

sub init {
	my ($self,$config) = @_;
	if(!$self->{residentCondensedStepsFilled}){
		$self->_fillResidentCondensedSteps();
		$self->{residentCondensedStepsFilled} = 1;
	}
	return $self->SUPER::init($config);
}

1;
