#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Installation summary dialog

package LCM::Gui::Dialogs::SummaryDialog;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxEXPAND wxLEFT wxRIGHT wxTOP wxBOTTOM wxALIGN_CENTER );
use Wx::Event qw (EVT_SIZE);

use base SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Gui::Design;
use SDB::Install::Globals;
use SAPDB::Install::Resources;
use LCM::SummaryTreeBuilder;
use LCM::Configuration::GenericStackAny qw (UPDATE_ACTION UNINSTALL_ACTION ADD_HOSTS REMOVE_HOSTS);
use LCM::Gui::Dialogs::UiComponentsFactory;
use strict;

our $is_gtk1 = 0;    #Wx::wxGTK1 ();

our $resources = new SAPDB::Install::Resources();
our $images    = $resources->getImages(qw(icon/warning.png icon/hint.png));

sub new {
	my ($self) = shift->SUPER::new(@_);

	my $sizer = Wx::BoxSizer->new(wxVERTICAL);

	$self->{id}   = 'summary';
	$self->{name} = 'Review & Confirm';

	if ( $^O =~ /mswin/i ) {
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new( $self, -1, [ -1, -1 ], [ -1, -1 ] );
	} else {    #   avoid Gdk warnings
		$self->Show(1);
		$self->{'tree_ctrl'} = Wx::TreeCtrl->new( $self, -1, [ -1, -1 ], [ -1, -1 ] );
		$self->Show(0);
	}

	$self->{'titel_big'} = CreateTitle($self, "Summary", $is_gtk1 );
	$self->{'warnings_icon'} = Wx::StaticBitmap->new( $self, -1, new Wx::Bitmap( $images->{'icon/warning.png'} ) );
	$self->{'warnings_text'} = CreateTitle($self, "", $is_gtk1 );
	$self->{'warnings_icon'}->Show(0);
	$self->{'warnings_text'}->Show(0);

    $self->{'info_icon'} = Wx::StaticBitmap->new( $self, -1, new Wx::Bitmap( $images->{'icon/hint.png'} ) );
    $self->{'info_text'} = CreateTitle($self, "", $is_gtk1 );
    $self->{'info_icon'}->Show(0);
    $self->{'info_text'}->Show(0);
    
	#   word-wrap $warnings_text at width of window
	my $handler = sub {
		my ( $dialog, $evt ) = @_;
		if ( $self->{'warnings_text_string'} ) {
			$self->{'warnings_text'}->SetLabel( $self->{'warnings_text_string'} );
			$dialog->{warnings_text}->Wrap( ( $dialog->GetSizeWH() )[0] - 10 - 20 - 20 );
		}
		if ( $self->{'info_text_string'} ) {
            $self->{'info_text'}->SetLabel( $self->{'info_text_string'} );
            $dialog->{info_text}->Wrap( ( $dialog->GetSizeWH() )[0] - 10 - 20 - 20 );
        }
		$dialog->Layout();
	};

	EVT_SIZE( $self, $handler );

	my $warning_sizer = new Wx::BoxSizer(wxHORIZONTAL);
	$warning_sizer->Add( $self->{'warnings_icon'}, 0, wxLEFT | wxTOP, 20 );
	$warning_sizer->AddSpacer(10);
	$warning_sizer->Add( $self->{'warnings_text'}, 0, wxEXPAND | wxTOP | wxALIGN_CENTER, 20 );

    my $info_sizer = new Wx::BoxSizer(wxHORIZONTAL);
    $info_sizer->Add( $self->{'info_icon'}, 0, wxLEFT | wxTOP, 20 );
    $info_sizer->AddSpacer(10);
    $info_sizer->Add( $self->{'info_text'}, 0, wxEXPAND | wxTOP | wxALIGN_CENTER, 20 );
    
	$sizer->Add( $warning_sizer, 0, wxEXPAND );
	$sizer->Add( $info_sizer, 0, wxEXPAND );
	$sizer->Add( $self->{'titel_big'}, 0, wxLEFT | wxTOP | wxBOTTOM, 20 );
	$sizer->Add( $self->{'tree_ctrl'}, 1, wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM, 20 );

	$self->SetSizer($sizer);
	$self->SetAutoLayout(1);

	return $self;
}

sub init {
	my ( $self, $config ) = @_;
	my $app        = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();
	$self->GetWizard->SetInstallMode( 1, $self->getInstallMode());
    $self->setNextLabel();
	my $component_manager = $instconfig->{componentManager};

	$instconfig->resetError();
	$app->resetError ();
	my $msg = $app->getMsgLst()->addMessage("Checking entire configuration (dialog $self->{name})");
	$msg->setEndTag('Configuration Check');
	$instconfig->setMsgLstContext( [ $msg->getSubMsgLst(), undef ] );
	if ( !$instconfig->CheckParams(1) ) {
		$app->ShowErrorMsg( 'Configuration Error', $instconfig->getErrMsgLst() );
		return { 'errstate' => 1 };
	}

	my $step = $instconfig->getStep();
	if ( defined $step ) {
		$step = int $step;
	} else {
		$step = 0;
	}

	my $summaryTree = $instconfig->createSummaryTree();
	my $warnings = $instconfig->getWarningList();
	if (@$warnings) {
		$self->{'warnings_text_string'} = join( "\n\n", @$warnings );
		$self->{'warnings_text'}->SetLabel( $self->{'warnings_text_string'} );
		$self->{'warnings_icon'}->Show(1);
		$self->{'warnings_text'}->Show(1);
	} else {
		$self->{'warnings_text'}->SetLabel("");
		$self->{'warnings_icon'}->Show(0);
		$self->{'warnings_text'}->Show(0);
	}
	
	my $infoMsgs = $instconfig->{infoMsgs}?$instconfig->{infoMsgs}:[];
    if (@$infoMsgs) {
        $self->{'info_text_string'} = join( "\n\n", @$infoMsgs );
        $self->{'info_text'}->SetLabel( $self->{'info_text_string'} );
        $self->{'info_icon'}->Show(1);
        $self->{'info_text'}->Show(1);
    } else {
        $self->{'info_text'}->SetLabel("");
        $self->{'info_icon'}->Show(0);
        $self->{'info_text'}->Show(0);
    }

	$self->_addTreeNode($summaryTree);

	#root
	$self->{'tree_ctrl'}->ExpandAll();
	$self->Layout();
	return {};
}

sub _addTreeNode {
	my ( $self, $summaryNodeRef, $parentTreeNode ) = @_;

	my $treeControl = $self->{'tree_ctrl'};
	my $currentTreeNode;
	my $currentNodeText = $summaryNodeRef->{"text"};
	if ( !defined $parentTreeNode ) {
		$currentTreeNode = $treeControl->AddRoot($currentNodeText);
	} else {
		$currentTreeNode = $treeControl->AppendItem( $parentTreeNode, $currentNodeText );
	}

	my $childrenRef = $summaryNodeRef->{"children"};
	if ( !defined $childrenRef ) {
		return;
	}
	$treeControl->SetItemFont( $currentTreeNode, SDBFONT_BoldText ) if ( !$is_gtk1 );
	$treeControl->SetItemText( $currentTreeNode, $currentNodeText ) if ( !$is_gtk1 );
	foreach my $childRef ( @{$childrenRef} ) {
		$self->_addTreeNode( $childRef, $currentTreeNode );
	}
}

sub Process {
	return {};
}

sub Back {
	$_[0]->{'tree_ctrl'}->DeleteAllItems();
	$_[0]->GetWizard->SetInstallMode(0);
	$_[0]->GetWizard()->EnableNextButton();
	return 1;
}

sub Destroy {
	my ($self) = @_;

	if ( defined $self->GetSizer ) {
		$self->GetSizer->Clear(1);
	}

	foreach my $element ( 'tree_ctrl', 'titel_big', ) {
		if ( defined $self->{$element} ) {
			delete $self->{$element};
		}
	}

	$self->SUPER::Destroy;
}

sub DESTROY {
	my ($self) = @_;
	print ">>>> destroying $self\n"
	  if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub getInstallMode{
    my $self = shift;
    my $app        = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    $instconfig->isUpdate() ? '&Upgrade' : undef
}

sub setNextLabel{
    my $self = shift;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    if ( $instconfig->getAction() eq UNINSTALL_ACTION ) {
        $self->GetWizard->{'nbutton'}->SetLabel("&Uninstall");
    } elsif ( $instconfig->getAction() eq UPDATE_ACTION ) {
        $self->GetWizard->{'nbutton'}->SetLabel("&Update");
    } elsif ( $instconfig->getAction() eq ADD_HOSTS ) {
        $self->GetWizard->{'nbutton'}->SetLabel("&Add Hosts");
    } elsif ( $instconfig->getAction() eq REMOVE_HOSTS ) {
        $self->GetWizard->{'nbutton'}->SetLabel("&Remove Hosts");
    }
}

1;
