package LCM::Gui::Dialogs::UiComponentsFactory;

use strict;
use parent qw(Exporter);
use SDB::Install::Gui::Design;
use Wx qw(wxCB_READONLY wxDefaultPosition wxDefaultSize);

our @EXPORT = qw(CreateTitle CreateRadioButton CreateComboBox CreateCheckListBox);

sub CreateTitle {
    my ($parentElement, $title, $isGtk1) = @_;
    my $staticText = new Wx::StaticText($parentElement, -1, $title, wxDefaultPosition, wxDefaultSize);

    $staticText->SetFont(SDBFONT_DialogTitle) if(!$isGtk1);
    return $staticText;
}

sub CreateRadioButton {
    my ($parentElement, $title, $isGtk1) = @_;
    my $button = new Wx::RadioButton($parentElement, -1, $title, wxDefaultPosition, wxDefaultSize);

    $button->SetFont(SDBFONT_NormalText) if(!$isGtk1);
    return $button;
}

sub CreateComboBox {
    my ($parentElement, $title, $isGtk1, $minSize, $size) = @_;
    my $comboBox = new Wx::ComboBox($parentElement, -1, $title, wxDefaultPosition, wxDefaultSize, [], wxCB_READONLY);

    $comboBox->SetFont(SDBFONT_NormalText) if(!$isGtk1);
    $comboBox->SetMinSize($minSize) if($minSize);
    $comboBox->SetSize($size) if($size);
    return $comboBox;
}

sub CreateCheckListBox {
    my ($parentElement, $isGtk1) = @_;
    my $checkListBox = new Wx::CheckListBox($parentElement, -1, wxDefaultPosition, wxDefaultSize);

    $checkListBox->SetFont(SDBFONT_NormalText) if(!$isGtk1);
    return $checkListBox;
}

1;