package LCM::Gui::Dialogs::UnregisterPropertiesDialog;

use base qw(SDB::Install::Gui::Dialogs::GenericParameter);
use Wx::Event qw(EVT_CHECKBOX);
use strict;

my $LABEL_TEMPLATE = "Unregister %s Parameters";
my $NAME_TEMPLATE = 'Enter Unregister %s Parameters';

sub new{
    my ($class, $scope, @args) = @_;
    my $self = $class->SUPER::new(@args);
    $scope = ucfirst($scope);
    
    $self->{label_text} = sprintf($LABEL_TEMPLATE, $scope);
	$self->{name} = sprintf($NAME_TEMPLATE, $scope);
    $self->{id} = 'unregisterScenarioDialog';
    
    return $self;
}

sub init {
	my $self = shift;
	my $returnValue = $self->SUPER::init(@_);
	my $keepUserCtrl = $self->{dynctrl}->{KeepUser_ctrl};
	my $keepUserHomeDirCtrl = $self->{dynctrl}->{KeepUserHomeDir_ctrl};
	EVT_CHECKBOX( $self, $keepUserCtrl->GetId(), \&_onKeepUserCheckBox );
	EVT_CHECKBOX( $self, $keepUserHomeDirCtrl->GetId(), \&_onKeepUserCheckBox );
	return $returnValue; 
}

sub getParamKeys{
    return ['RootUser', 'RootPassword', 'HostagentPassword', 'Password', 'KeepUser', 'KeepUserHomeDir'];
}

sub Process{
    my $self = shift;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{'instconfig'};

    $instconfig->setMandatory('RootPassword', 0);
    $instconfig->setBatchValueOfRequiredParams('InstallSSHKey');

    my $returnValue = $self->SUPER::Process(@_);
    if (defined $returnValue && !$instconfig->getErrMsgLst()->isEmpty()) {
        my $productName = $instconfig->getProductName();
        $app->ShowErrorMsg("$productName failed", $instconfig->getErrMsgLst());
        $returnValue = {'errstate' => 1};
    }
    return $returnValue;
}

sub _onKeepUserCheckBox {
    my ($self) = @_;
    my $isChecked = $self->{dynctrl}->{KeepUser_ctrl}->IsChecked();
    $self->{dynctrl}->{KeepUserHomeDir_ctrl}->SetValue(1) if ($isChecked);
}

1;