package LCM::Gui::Dialogs::Update::AddHostsPanel;

use strict;
use Wx qw ( wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD);
use LCM::Gui::DialogUtilities qw ( GetAppConfig );
use parent 'LCM::Gui::Dialogs::HostsPanel';

sub newFieldsSizer {
	my ($self) = @_;
	my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
	return $self->fieldsSizer( $instconfig);
}

sub fieldsSizer {
	my ($self, $instconfig) = @_;
	my $sizer = new Wx::FlexGridSizer( 3, 2, 5, 10 );

	$sizer->SetFlexibleDirection(wxHORIZONTAL);
	$sizer->AddGrowableCol(1);
	if(! $instconfig->isUseSAPHostagent()){
		$self->_addParamInput('RootUser', $instconfig, $sizer);
		$self->_addParamInput('RootPassword', $instconfig, $sizer);
	} else {
		$self->_addParamInput('HostagentPassword', $instconfig, $sizer);
	}
	$self->_addAutoAddXs2RolesCheckBox($sizer, $instconfig);

	my $window = $self->getWindow();
	$window->{_fieldsSizer} = $sizer;
	return $sizer;
}

sub setFieldProperties{
	my ($self,$instconfig) = @_;
}

sub newAddHostsSizer {
	my ( $self ) = @_;
	my $sizer = new Wx::BoxSizer(wxVERTICAL);

	$self->addHostsPanel($sizer);
	return $sizer;
}

sub _onAssignRoles {
	my ($self, $window) = @_;
	$self->SUPER::_onAssignRoles($window);
	$window->_handleAutoAddCheckBox();
}

sub _onRemoveHost {
	my ($self, $window) = @_;
	$self->SUPER::_onRemoveHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onEditHost {
	my ($self, $window) = @_;
	$self->SUPER::_onEditHost($window);
	$window->_handleAutoAddCheckBox();
}

sub _onAddHost {
	my ($self, $window) = @_;
	$self->SUPER::_onAddHost($window);
	$window->_handleAutoAddCheckBox();
}

1;