package LCM::Gui::PagePredicates;

use strict;
use warnings;

use SDB::Install::Globals qw ($gProductNameEngine);

use Exporter;
use base qw ( Exporter );
our @EXPORT_OK = qw (   ShouldSkipUpgradeProperties
                        ShouldSkipAdditionalHostsProperties
                        ShouldSkipCertificatesDialog
                        ShouldSkipHostagentPasswordPage
                        ShouldSkipUserProperties
                        ShouldSkipStreamingPropertiesPage
                        ShouldSkipEsStoragePage
                        ShouldSkipAcceleratorPropertiesPage
                        ShouldSkipInternalNetworkPropertiesPage
                        ShouldSkipOSLevelCredentials
                        ShouldSkipDatabaseCredentials
                        ShouldSkipXSPropertiesPage
                        ShouldSkipXSSpaceIsolationPropertiesPage
                        ShouldSkipXSAdvancedRenamePropertiesPage
                        ShouldSkipSelectXSApplicationsPage
                        ShouldSkipSelectedComponentsDialog
                        ShouldSkipMasterPassword
                        ShouldSkipSQLUserProperties
                        ShouldSkipSystemPropertiesPage
                        ShouldSkipLSSPropertiesDialog
                        ShouldSkipCockpitStackPropertiesDialog
                        ShouldSkipKeepCockpitTenantDialog
                        ShouldSkipCockpitTenantCredentialsDialog
                        ShouldSkipXSTenantDatabaseCredentialsDialog);

sub ShouldSkipMasterPassword {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    return $instconfig->isSkipped('MasterPassword');
}

sub ShouldSkipSQLUserProperties {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isSkipped = $instconfig->isSkipped('SQLSysPasswd');
    my $isHidden = $instconfig->isHidden('SQLSysPasswd');

    return ($isHidden || $isSkipped) ? 1 : 0;
}

sub ShouldSkipUpgradeProperties {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isRootUserSkipped = $instconfig->isSkipped('RootUser');
    my $isPasswordSkipped = $instconfig->isSkipped('Password');
    my $isRootPasswordSkipped = $instconfig->isSkipped('RootPassword');
    my $isSQLSysPasswdSkipped = $instconfig->isSkipped('SQLSysPasswd');
    
    my $returnFlag = (  $isPasswordSkipped and $isRootUserSkipped and 
                        $isRootPasswordSkipped and $isSQLSysPasswdSkipped ) ? 1 : 0;
    return $returnFlag;
}

sub ShouldSkipAdditionalHostsProperties {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isInSimpleMode = $instconfig->getValue('UseSimpleUI') ? 1 : 0;
    return $instconfig->isSkipped('AddHosts') || $isInSimpleMode;
}

sub ShouldSkipCertificatesDialog{
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isSkipped = $instconfig->isSkipped('CertificatesHostmap');
    return $isSkipped;
}

sub ShouldSkipOSLevelCredentials{
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isSkippedRootUser = $instconfig->isSkipped('RootUser');
    my $isSkippedPassword = $instconfig->isSkipped('Password');
    my $isSkippedRootPassword = $instconfig->isSkipped('RootPassword');
    my $isSkippedHostagentPassword = $instconfig->isSkipped('HostagentPassword');
    return $isSkippedRootUser && $isSkippedRootPassword && $isSkippedHostagentPassword && $isSkippedPassword;
}

sub ShouldSkipHostagentPasswordPage {
	my $instconfig = Wx::wxTheApp()->getInstconfig();

	if($instconfig->isa ( 'LCM::Configuration::RenameSystemConfiguration' ) && $instconfig->isRegisterScenario()) {
		return $instconfig->isSkipped('HostagentPassword');
	}

	if ($instconfig->isa ('LCM::Configuration::Hosts::AddHosts::AddHostsBaseConfiguration')) {
        if ($instconfig->{params}->{HostagentPassword}->{skip} == 0) {
        	# Case of addhost via SHA
            return 1;
        }
	}
	
    my $isSkipped = $instconfig->isSkipped('InitialHostagentPassword');
    return $isSkipped;
}

sub ShouldSkipUserProperties {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    
    my $isRootUserSkipped = $instconfig->isSkipped('RootUser');
    my $isRootPasswordSkipped = $instconfig->isSkipped('RootPassword');
    my $isPasswordSkipped = $instconfig->isSkipped('Password');
	
	return ( ( $isPasswordSkipped and  $isRootUserSkipped and $isRootPasswordSkipped ) ? 1 : 0 );
}

sub ShouldSkipStreamingPropertiesPage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isPasswordSkipped = $instconfig->isSkipped('StreamingClusterManagerPassword') || $instconfig->isHidden('StreamingClusterManagerPassword');
    my $isBasepathSkipped = $instconfig->isSkipped('BasepathStreaming') || $instconfig->isHidden('BasepathStreaming');

    return ($isPasswordSkipped && $isBasepathSkipped) ? 1 : 0 ;
}

sub ShouldSkipDatabaseCredentials {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my @relevantParams = qw(SystemUser SQLSysPasswd AcceleratorUser AcceleratorPassword TenantUser SQLTenantUserPassword);
    my @skippedParams = grep { $instconfig->isSkipped($_) } @relevantParams;
    return @relevantParams == @skippedParams ? 1 : 0;
}

sub ShouldSkipEsStoragePage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isEsDataPathSkipped = $instconfig->isSkipped('EsDataPath');
    my $isEsLogPathSkipped = $instconfig->isSkipped('EsLogPath');

    return ($isEsDataPathSkipped && $isEsLogPathSkipped) ? 1 : 0;
}

sub ShouldSkipSystemPropertiesPage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my @params = qw (AcceleratorUser AcceleratorPassword
                     AcceleratorDataPath AcceleratorLogPath
                     OrgManagerUser OrgManagerPassword);
    for (@params){
        next unless(exists($instconfig->{params}->{$_}));
        return 0 if ($instconfig->isAutoInitializeServicesRequired());
        return 0 if(!$instconfig->isSkipped($_) && !$instconfig->isHidden($_));
    }
    return 1;
}

sub ShouldSkipAcceleratorPropertiesPage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    for my $parameterId ('AcceleratorUser', 'AcceleratorPassword', 'AcceleratorDataPath', 'AcceleratorLogPath'){
        next unless(exists($instconfig->{params}->{$parameterId}));
        return 0 if(!$instconfig->isSkipped($parameterId) && !$instconfig->isHidden($parameterId));
    }
    return 1;
}

sub ShouldSkipInternalNetworkPropertiesPage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    if(!defined $instconfig->{params}->{'ListenInterface'}){
    	return 1;
    }
    return $instconfig->isSkipped('ListenInterface') ? 1 : 0;
}

sub ShouldSkipXSPropertiesPage {
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $params = $instconfig->{params};
	my $parameterIds = ['InstallXSInDefaultTenant', 'XSTenantDatabaseName', 'XsEaDataPath', 'OrgManagerUser', 'OrgManagerPassword', 'OrgName', 'ProdSpaceName', 'XsDomainName', 'XSSpaceIsolation'];
	my $unskippedParametersCount  = scalar (grep {defined($params->{$_}) && !$instconfig->isSkipped($_) && !$instconfig->isHidden($_)} @{$parameterIds});
	return $unskippedParametersCount == 0;
}

sub ShouldSkipXSSpaceIsolationPropertiesPage {
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $parameterIds = ['XSSpaceUserIdSAP', 'XSSpaceUserIdProd'];
	my $unskippedParametersCount  = scalar (grep {!$instconfig->isSkipped($_) && !$instconfig->isHidden($_)} @{$parameterIds});
	return $unskippedParametersCount == 0;
}

sub ShouldSkipXSAdvancedRenamePropertiesPage {
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $parameterIds = ['XSSpaceUserIdSAP', 'XSSpaceUserIdProd', 'XsEaDataPath'];
	my $unskippedParametersCount  = scalar (grep {!$instconfig->isSkipped($_) && !$instconfig->isHidden($_)} @{$parameterIds});
	return $unskippedParametersCount == 0;
}

sub ShouldSkipSelectXSApplicationsPage {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $isInSimpleMode = $instconfig->getValue('UseSimpleUI');
    return $instconfig->isSkipped('SelectedXs2Applications') || $isInSimpleMode ? 1 : 0;
}

sub ShouldSkipSelectedComponentsDialog {
	my ($self, ) = @_;
	my $externalDetectedComponents = Wx::wxTheApp()->getInstconfig()->getMediumComponentManager()->getExternalDetectedComponents();
	return ( scalar @$externalDetectedComponents == 1 && @$externalDetectedComponents[0]->getComponentName() eq $gProductNameEngine) ? 1 : 0;
}

sub ShouldSkipLSSPropertiesDialog {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    my $parameterIds = $instconfig->getLSSParams();
    my $unskippedParametersCount  = scalar (grep {!$instconfig->isSkipped($_) && !$instconfig->isHidden($_)} @{$parameterIds});
    return $unskippedParametersCount == 0;
}

sub ShouldSkipCockpitStackPropertiesDialog {
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    for my $parameterId ('CockpitXSSpace'){
        next unless(exists($instconfig->{params}->{$parameterId}));
        return 0 if(!$instconfig->isSkipped($parameterId) && !$instconfig->isHidden($parameterId));
    }
    return 1;
}

sub ShouldSkipKeepCockpitTenantDialog {
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    for my $parameterId ('CockpitXSSpace', 'CockpitTenant', 'KeepCockpitTenant'){
        next unless(exists($instconfig->{params}->{$parameterId}));
        return 0 if(!$instconfig->isSkipped($parameterId) && !$instconfig->isHidden($parameterId));
    }
    return 1;
}

sub ShouldSkipCockpitTenantCredentialsDialog {
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    for my $parameterId ('CockpitTenantUser','CockpitTenantUserPassword'){
        next unless(exists($instconfig->{params}->{$parameterId}));
        return 0 if(!$instconfig->isSkipped($parameterId) && !$instconfig->isHidden($parameterId));
    }
    return 1;
}

sub ShouldSkipXSTenantDatabaseCredentialsDialog {
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    return !$instconfig->useNonDefaultTenantForXSA();
}

1;
