package LCM::Hosts::RemoveHostCheck;

use strict;
use warnings;
use parent qw(SDB::Install::Base);
use LCM::Hosts::HostsDetector;
use SDB::Install::Globals qw($gHostRoleWorker);
use SDB::Install::System qw (isSidadmin);

sub new{
    my $class = shift;
    my $self =  $class->SUPER::new (@_);
    return $self;
}

sub check{
    my ($self,$config,$detector,$hostsForRemoveUserInputString) = @_;
    my $hostsForRemoval = $detector->getHostsFromUserInput($hostsForRemoveUserInputString, 1);

    if( scalar(@{$hostsForRemoval}) <= 0) {
        $self->getErrMsgLst()->addMessage("Choose another hosts for removal from the current landscape.");
        return 0;
    }
    return 0 if(!$self->_checkNotAllWorkersSelected($detector,$hostsForRemoveUserInputString));
    my $hasLocalHost =  $detector->userInputContainsLocalhost($hostsForRemoveUserInputString);
    if($hasLocalHost){
        return 0  if(!$self->canRemoveLocalhost($config,$detector,$hostsForRemoveUserInputString));
    }
    my $hasRemoteHosts = $detector->userInputContainsRemoteHosts($hostsForRemoveUserInputString);
    if($hasRemoteHosts){
        return  $self->canRemoveRemoteHosts($config, $detector,$hostsForRemoveUserInputString);
    }
    return 1;
    }

sub canRemoveLocalhost {
    my ($self,$config,$detector, $hostsForRemoveUserInputString) = @_;

    return 0 if($config->isCurrentUserSidadm());
    my $localHost = $detector->_getLocalHostName();
    if($detector->hasStandByRole($localHost)){
        return $self->_canRemoveHost($detector,$localHost,$config);
    }
    
# if the node is not a STANDBY role same rules apply as with remote hosts
    return $self->canRemoveRemoteHosts($config,$detector,$hostsForRemoveUserInputString);
}

sub canRemoveRemoteHosts {
    my ($self, $config, $detector,$hostsForRemoveUserInputString) = @_;
    my $hostsForRemoval = $detector->getHostsFromUserInput($hostsForRemoveUserInputString, 1);
    for my $host (@{$hostsForRemoval}){
        return 0 if(!$self->_canRemoveHost($detector,$host,$config)); # Check is based on actual host status
    }
    return 1;
}

sub _checkNotAllWorkersSelected{
    my ($self ,$detector,$hostsForRemoveUserInputString) = @_;
    my $hostsForRemoval = $detector->getHostsFromUserInput($hostsForRemoveUserInputString, 1);
    my $allWorkersSelectedForRemoval = $detector->areAllWorkersInUserInput($hostsForRemoveUserInputString);
    if(! defined $allWorkersSelectedForRemoval){
        return 1;
    }
    if ($allWorkersSelectedForRemoval) {
        $self->getErrMsgLst()->addMessage("Cannot remove all '" . $gHostRoleWorker . "' nodes of the system.");
        return 0;
    }
    return 1;
}
sub _canRemoveHost {
    my ($self, $detector, $host, $config) = @_;
    my $hdbInstance = $detector->_getInstance();

    $hdbInstance->setMsgLstContext ([$self->getMsgLst ()]);
    if ($hdbInstance->hostIsActiveMaster($host)){
        $self->getErrMsgLst()->addMessage("Host '$host' is the active nameserver master. Cannot remove the active nameserver master");
        return 0;
    }

    my $namesrvUtility = $hdbInstance->getNameServerUtility();
    $namesrvUtility->setMsgLstContext ([$self->getMsgLst (), $self->getErrMsgLst()]);
    my $hostRemoveStatus = $namesrvUtility->checkCanRemoveHost($host, $config);
    if (!$hostRemoveStatus){
        return 0;
    }
    return 1;
}

1;