package LCM::HostsUtility;

use strict;

use SDB::Install::SAPSystem qw(CollectSAPSystems);
use SDB::Install::Globals qw( $gProductName $gProductNameSystem );
use SDB::Install::SysVars qw($path_separator);

use base qw ( Exporter );

our @EXPORT_OK = qw ( IsHostPartOfSystem GetNumberOfSystemHosts GetInstanceDirOnHostNotPartOfSystem );

sub IsHostPartOfSystem {    
    require LCM::Installer;
    my $installer = new LCM::Installer();
    my $sid = $installer->getSid();
    my $allSystems = CollectSAPSystems( undef, 1 );
    my $isHostPartOfSystem = grep { $_ eq $sid } (keys %$allSystems);
    return $isHostPartOfSystem;
}

sub GetNumberOfSystemHosts {
    require LCM::Installer;
    my $installer  = new LCM::Installer();
    my $sid        = $installer->getSid();
    my $allSystems = CollectSAPSystems( undef, 1 );
    my $sapSys     = (defined $sid) ? $allSystems->{$sid} : undef;
    my $instance   = (defined $sapSys && $sapSys->hasNewDB())
                     ? $sapSys->getNewDBInstances()->[0] : undef;
    my $allHosts   = (defined $instance) ? $instance->get_allhosts() : undef;

    return (defined $allHosts) ? scalar @$allHosts : 0;
}

sub GetInstanceDirOnHostNotPartOfSystem {
    my ($context, $sapSidDir) = @_;

    if (!opendir (DH, $sapSidDir)){
        $context->PushError ("Cannot open directory \"$sapSidDir\": $!") if (defined $context);
        return undef;
    }

    my $instanceDirPattern = 'HDB\d\d';
    my @instanceDirs = grep {-d "$sapSidDir/$_" && /$instanceDirPattern/} readdir (DH);

    closedir (DH);
    
    if( !@instanceDirs ){
        $context->PushError ("There are not $gProductName instance directories in directory \"$sapSidDir\"") if (defined $context);
        return undef;
    }
    
    if(scalar @instanceDirs > 1){
        $context->PushError ("In directory \"$sapSidDir\" exists more than one $gProductName instance directories") if (defined $context);
        return undef;
    }

    my $sapSidInstanceDir = $sapSidDir . $path_separator . $instanceDirs[0];

    return $sapSidInstanceDir;
}

1;
