package LCM::Manifests::SAPSignature;

use strict;
use parent 'SDB::Install::Base';
use File::stat;
use LCM::FileUtils qw(readFile);
use SDB::Install::MsgLst;

sub new {
    my ($class, $signaturePath) = @_;
    my $self = bless({
        contents => [],
    }, $class);

    $self->{signaturePath} = $signaturePath;
    $self->read();

    return $self;
}

sub getSignatureFilePath {
    my ($self) = @_;
    return $self->{signaturePath};
}

sub getContents {
    my ($self) = @_;
    return $self->{contents};
}

sub read {
    my ($self) = @_;
    my $filePath = $self->getSignatureFilePath();
    if (!$filePath) {
        $self->setErrorMessage("Can't create SAPSignature from empty file path.");
        return undef;
    }
    my $errMsgLst = SDB::Install::MsgLst->new();
    my $signatureContents = readFile($filePath, $errMsgLst);
    if (!defined($signatureContents)) {
        $self->setErrorMessage("Failed to read signature file '$filePath'", $errMsgLst);
        return undef;
    }
    $self->{contents} = $signatureContents;
}

sub containsEntry {
    my ($self, $entry, $isRegex) = @_;
    for my $line (@{$self->getContents()}) {
        my $pattern = $isRegex ? $entry : qr/\Q$entry/;
        if ($line =~ $pattern) {
            return $line;
        }
    }
    return undef;
}

sub setIsValid {
    my($self, $isValid) = @_;
    $self->{isValid} = $isValid;
}

sub isValid {
    my ($self) = @_;
    return $self->{isValid} // 0;
}

sub readComponentManifestPath {
    my ($self,$component) = @_;
    my $dirNameContainingComponentManifest = $component->getManifestDirname();
    my $manifestPathInSignatureLine = $self->containsEntry(qr/$dirNameContainingComponentManifest\/+manifest$/, 1);
    return (defined $manifestPathInSignatureLine && $manifestPathInSignatureLine =~ /(\S+\/+manifest$)/) ? $1 : undef;
}

sub belongsToComponent {
    my ($self,$component) = @_;
    if (! defined $self->readComponentManifestPath($component)) {
        return 0;
    }
    return 1;
}

1;