package LCM::Manifests::XS2ApplicationManifest::InstalledXS2ApplicationManifest;

use strict;
use parent 'LCM::Manifests::XS2ApplicationManifest';


sub new {
	my ($class, $cmpRegistryNode) = @_;
	my $self = bless {}, $class;
	$self->{data} = {};

	$self->_parseNode($cmpRegistryNode);
	return $self;
}

sub _parseNode {
	my($self, $componentNode) = @_;
	my $componentKeyElement = $componentNode->getElementsByTagName('name')->[0];
	my $releaseElement = $componentNode->getElementsByTagName('release')->[0];
	my $spLevelElement = $componentNode->getElementsByTagName('sp-level')->[0];
	my $patchLevelElement = $componentNode->getElementsByTagName('patch-level')->[0];
	my $captionElement = $componentNode->getElementsByTagName('caption')->[0];
	my $ppmsIdElement = $componentNode->getElementsByTagName('ppmsid')->[0];

	$self->{data}->{'ppmsid'} = defined($ppmsIdElement) ? $ppmsIdElement->textContent() : '';
	$self->{data}->{'component-key'} = defined($componentKeyElement) ? lc($componentKeyElement->textContent()) : '';
	$self->{data}->{'keyname'} = $self->{data}->{'component-key'};
	$self->{data}->{'keycaption'} = defined($captionElement) ? $captionElement->textContent() : $self->{data}->{'keyname'};
	$self->{data}->{'release'} = defined($releaseElement) ? $releaseElement->textContent() : '';
	$self->{data}->{'rev-number'} = defined($spLevelElement) ? $spLevelElement->textContent() : '';
	$self->{data}->{'rev-patchlevel'} = defined($patchLevelElement) ? $patchLevelElement->textContent() : '';
}

#Override
sub getCompId {
	my ($self) = @_;
	return $self->getValue('ppmsid');
}

#Override
sub isPlatformSupported {
	#Application is already installed
	return 1;
}

#Override
sub isXS2Application {
	my ($self) = @_;
	return 1;
}

1;
