package LCM::Persistence::IniToXMLAdapterBase;

use strict;

use SDB::Install::Globals qw ($gProductNameEngine);
use SDB::Install::SAPSystem qw (@STEP_NAMES @UPGRADE_STEP_NAMES);

use parent 'LCM::Persistence::XMLBase';

sub new {
	my ($class, $filePath, $configuration) = @_;
	my $self = $class->SUPER::new($filePath);

	$self->_setConfiguration($configuration);

	if (!defined $self->_loadIniData()) {
		my $errMsg = "Error loading data from file '$filePath'";
		$self->setErrorMessage($errMsg);
		$self->_setExistsMandatoryValidationError(1);
	}

	return $self;
}

sub getTargetVersionString {
	my ($self) = @_;
	return $self->_getFileContent()->{'_kitversion'} || '<unknown>';
}

sub getComponentNameString {
	my ($self) = @_;
	return $gProductNameEngine;
}

sub getCurrentStepString {
	my ($self) = @_;
	my $curentStep = $self->_getFileContent()->{'step'};
	my $hdbIniExtention = (split('\.', $self->getFilePath()))[-1];
	my $curentStepName = $hdbIniExtention eq 'hdbinstall' ? $STEP_NAMES[$curentStep] : $UPGRADE_STEP_NAMES[$curentStep];
	return $curentStepName || '<unknown>';
}

sub getNextPhaseString {
	my ($self) = @_;
	return $self->_getFileContent()->{'next_phase'}  || '<unknown>';
}

#
# Only private subs below this line
#

sub _loadIniData {
	my ($self) = @_;
	my $configuration = $self->_getConfiguration();
	my $filePath = $self->getFilePath();

	if (!$configuration->pers_exists($filePath)) {
		return undef;
	}

	my $dateStr = $configuration->pers_date_string();
	$self->_setCreationDateString($dateStr);

	my $fileContent = $configuration->pers_load($filePath);
	$self->_setFileContent($fileContent);

	return undef if (!defined $fileContent);
	return 1;
}

sub _setConfiguration {
	my ($self, $configuration) = @_;
	$self->{_configuration} = $configuration;
}

sub _getConfiguration {
	my ($self) = @_;
	return $self->{_configuration};
}

sub _setFileContent {
	my ($self, $fileContent) = @_;
	$self->{_fileContent} = $fileContent;
}

sub _getFileContent {
	my ($self, $fileContent) = @_;
	return $self->{_fileContent};
}

sub _setCreationDateString {
	my ($self, $dateString) = @_;
	$self->{_creationDate} = $dateString;
}

1;
