package LCM::Python::PythonExecutor;

use base qw(SDB::Install::Base);
use SDB::Install::SysVars qw($isWin);
use File::Spec;
use LCM::Installer;
use strict;
#####################################################################################
# 							Author : Martin Lakov									#
#####################################################################################
#		Helper class for generation and execution of python scrypts					#
#####################################################################################


#	Constructor takes 2 arguments hdb instance (see AnyConfig -> getOwnInstance())
#	and LCM::Installer object, from which it gets the hdblcm runtime dir
#	in the constructor it collects the necessary info to set the python environment
sub new{
	my ($class, $hdbInstance, $doNotSetEnvironment, $progressHandler) = @_;
	my $self = bless({}, $class);
	my $exeDir = $hdbInstance->get_instanceExeDir();

	$self->{_exeDir} = $exeDir;
	$self->{_pythonExe} = File::Spec->catfile($exeDir, 'Python', 'bin', 'python');
	$self->{_sapRetrievalPath} = $hdbInstance->get_hostNameDir();
	$self->{_secuDir} = File::Spec->catfile($hdbInstance->get_hostNameDir(), 'sec');
	$self->{_globalTrexInstallDir} = $hdbInstance->get_globalTrexInstallDir();
	$self->{_doNotSetEnvironment} = $doNotSetEnvironment;
	$self->{_progressHandler} = $progressHandler;
	$self->{_hdbInstance} = $hdbInstance;

	return $self;
}

#	_executePythonCommand gets a script , error message, array ref with the
#	script's arguments and uid and gid to switch to for the execution, then sets the
#	environment and tries to execute the script with the given args
sub _executePythonCommand{
	my ($self, $script, $errorMessage, $args, $uid, $gid) = @_;
	
	my $command = $self->{_pythonExe};
	unshift @$args, '-';
	my $executor = new LCM::ProcessExecutor($command, $args, [$script], undef, undef, $uid, $gid);
	$executor->setOutputHandler($self->{_progressHandler});
	my $exitCode;
	
	if($self->{_doNotSetEnvironment}){
		$exitCode = $executor->executeProgram();
	} else {
		$exitCode = $self->_setEnvironmentAndExecute($executor);
	}
	
	$self->getMsgLst()->addMessage(undef, $executor->getMsgLst());
	if(!defined($exitCode) || $exitCode) {
		$self->getErrMsgLst()->addMessage(undef, $executor->getErrMsgLst());
		$self->getErrMsgLst()->addMessage($errorMessage);
		return undef;
	}
	
	if(wantarray){
	 	return (1, $executor);
	}
 	return 1;
}

sub _setEnvironmentAndExecute {
	my ($self, $executor) = @_;
	my $hdbInstance = $self->{_hdbInstance};

	local %ENV = (); # Preset environment for execution of python as root
	$hdbInstance->_getHDBEnv(\%ENV);

	return $executor->executeProgram();
}

sub getPermissions
{
    my ($self, $sid) = @_;
    return (undef, undef) if $isWin;    
    my $uid = getpwnam((lc ($sid)) . 'adm');
    my $gid = getgrnam('sapsys');
    return ($uid, $gid);
}

1;