package LCM::SHA::DeploymentCache;

use strict;

my $new = sub {
	my $class = shift();
	return bless({ _deployedOnHosts => {} }, $class);
};
my $instance = $new->('LCM::SHA::DeploymentCache');

sub getInstance { return $instance; }

sub setDeployedOnHost {
	my ($self, $host) = @_;
	$self->{_deployedOnHosts}->{$host} = 1;
}

sub isDeployedOnHost {
	my ($self, $host) = @_;
	return $self->{_deployedOnHosts}->{$host};
}

1;