package LCM::SHA::DeploymentStrategy::DetectManagedObjects;

use strict;
use File::Basename;
use File::Spec;
use LCM::FileUtils;
use base qw(LCM::SHA::DeploymentStrategy);
use SDB::Install::Globals qw($gSignatureManifestName);

sub _deployOnHost {
	my ($self, $hostctrl) = @_;
	my $pathToSignatureManifest = $self->getPathToSignatureManifest();
	if(!-e $pathToSignatureManifest){
		$pathToSignatureManifest = $self->_determinePathToManifest();
	}
	if(-e $pathToSignatureManifest){
		my $fileContent = LCM::FileUtils::readFile($pathToSignatureManifest, $self->getErrMsgLst());
		my $isCockpitInMasterSignature = $self->isCockpitInMasterSignature ($fileContent);
		my $rc = $hostctrl->DetectManagedObjects($pathToSignatureManifest);
		if (!$isCockpitInMasterSignature){
				my $pathToCockpitSignatureManifest = $self->getCockpitSignatureFile ($pathToSignatureManifest);
				if (defined $pathToCockpitSignatureManifest){
					$self->{_cockpitSignature} = $pathToCockpitSignatureManifest;
				}
				else{
					$self->getMsgLst()->addWarning ("HANA Offline Cockpit deployment is skipped.");
				}
		}
		return $rc;
	}
	return $hostctrl->DetectManagedObjects();
}

sub _shallDeployCockpit{
    return defined $_[0]->{_cockpitSignature};
}

sub _deployCockpitOnHost {
    my ($self, $hostctrl) = @_;
    return $hostctrl->DetectManagedObjects($self->{_cockpitSignature});
}


sub getPathToSignatureManifest {
	my ($self) = @_;
	if(!exists($self->{_pathToManifest})){
		$self->{_pathToManifest} = $self->_determinePathToManifest();
	}
	return $self->{_pathToManifest};
}

sub setPathToSignatureManifest {
	my ($self, $pathToSignatureManifest) = @_;
	$self->{_pathToManifest} = $pathToSignatureManifest;
}

sub _determinePathToManifest {
	return File::Spec->catfile(dirname(LCM::Installer->new()->GetRuntimeDir()), $gSignatureManifestName);
}

1;
