package LCM::Slpp::ParameterAdapter::SelectionParameter;

use strict;
use experimental qw (smartmatch);

use base qw(LCM::Slpp::ParameterAdapter::TableParameter);

sub getSlppValue {
	my ($self) = @_;
	my $selectedValues = $self->getInternalSelectedValues();
	return $self->_getSlppTableValue($selectedValues);
}

sub getSlppBatchValue {
	my ($self) = @_;
	my $batchValues = $self->getInternalBatchValues();
	return $self->_getSlppTableValue($batchValues);
}

sub getDefaultSlppTableValue {
	my ($self) = @_;
	my $selectedValues = $self->getInternalDefaultValues();
	return $self->_getSlppTableValue($selectedValues);
}

sub _getSlppTableValue {
	my ($self, $selectedValues) = @_;
	my $hdblcmParameter = $self->{hdblcmRepresentation};
	my $paramId = $self->{parameterID};
	my @validAliasValues = exists($hdblcmParameter->{visible_alias_values}) ? @{$hdblcmParameter->{visible_alias_values}} : @{$hdblcmParameter->{valid_values}};
	my @validValues = @{$hdblcmParameter->{valid_values}};
	my @uiValues = undef;

	if ($hdblcmParameter->{ui_values}) {
		@uiValues = @{$hdblcmParameter->{ui_values}};
	}

	my $value = $hdblcmParameter->{value};
	my $valueTemplate = [];
	
	for my $i (0 .. $#validValues) {
		my $validAliasValue = $validAliasValues[$i];
		my $validValue = $validValues[$i];
		my $isSelected = $validValue ~~ @{$selectedValues}; 
		my $tuple = { 
			Tuple => {
				id 		=> $self->_getTupleIdByKey($validValue),
				value 	=> [
						{
							Parameter => {
								id 		=> "key",
								value 	=> $validAliasValue
							}
						},
						{	Parameter => {
								id 		=> "selected",
								value	=>  $self->_getSlppBoolean($isSelected)
							}
						},
						(
							@uiValues ? (						
							{	Parameter => {
									id 		=> "label",
									value	=>  $uiValues[$i]
								}
							}) : ()
						),
				]
			}
		};
		push(@{$valueTemplate}, $tuple);
	}
	
	return $valueTemplate;
}

sub getInternalSelectedValues() {
	die "Must be implemented in concrete classes";
}

sub getInternalDefaultValues {
	die "Must be implemented in concrete classes";
}

sub getInternalBatchValues {
	die "Must be implemented in concrete classes";
}

sub getStructure {
	my ($self) = @_;
	my $paramId = $self->{parameterID};
	my $hdblcmParameter = $self->{hdblcmRepresentation};
	my $uiValues = $hdblcmParameter->{ui_values};
	return [
		{	Parameter => {
				id 		=> "key",
				type 	=> 'slp.parameter.type.SCALAR'
			},
		},
		{
			Parameter => {
				id 		=> "selected",
				type 	=> 'slp.parameter.type.SCALAR'
			}
		},
		(
			$uiValues ? (						
			{	Parameter => {
					id 		=> "label",
					type 	=> 'slp.parameter.type.SCALAR'
				}
			}) : ()
		),		
	];
}

sub _parseSelectedValues {
	my ($self, $slppRepresentation, $batchValue) = @_;
	my $paramId = $self->{parameterID};
	

	my $tablevalue = $batchValue ? $slppRepresentation->{$self->getSlppBatchValueTag()} : $slppRepresentation->{$self->getSlppValueTag()};
	my @selectedValues = ();
	for my $tupleHash (@$tablevalue) {
		my $paramsArray = $tupleHash->{Tuple}->{value};
		my $selected = undef;
		my $selectedValue = undef;
		for my $parameter (@$paramsArray) {
			if ($parameter->{Parameter}->{id} eq "key") {
				$selectedValue = $parameter->{Parameter}->{value};
			} elsif ($parameter->{Parameter}->{id} eq "selected") {
				$selected = $parameter->{Parameter}->{value};
			}
		}
		
		if ($selected && $selected ne 'false') {
			push (@selectedValues, $selectedValue);
		}
	}
	
	return \@selectedValues;
}

1;
