package LCM::Slpp::SlppProcessTaskListener;

use strict;
use parent 'LCM::Task::BaseTaskListener';

sub new{
	# arguments come from the shared objects (between the threads) in the SlppExecutionHandler
	my ($class, $scenarioExecutor) = @_;
	my $self = $class->SUPER::new();
	$self->_setScenarioExeutor($scenarioExecutor);

	return $self;
}

sub _setScenarioExeutor {
	my ($self, $scenarioExecutor) = @_;
	$self->{scenarioExecutor} = $scenarioExecutor;
}

sub _getScenarioExecutor {
	my ($self) = @_;
	return $self->{scenarioExecutor};
}

sub notifyTaskChanged{
	my ($self, $task) = @_;
	my $scenarioExecutor = $self->_getScenarioExecutor();
	$scenarioExecutor->sendProgress($task->getProgress());
	$scenarioExecutor->sendProgressMessage($task->getLastProgressMessage(), 1);
}

1;