package LCM::Slpp::SlppProgressHandler;

use base SDB::Install::ProgressHandler;
use LCM::Slpp::ExecutionState qw(STATE_INITIAL STATE_RUNNING STATE_FINISHED STATE_ERROR STATE_DIALOG STATE_ABORTED getApplicableActions);
use SDB::Common::Utils qw( trim );

sub new {
    my ($class, $scenarioExecutor) = @_;
    my $self = $class->SUPER::new();
    $self->{scenarioExecutor} = $scenarioExecutor;

    return $self;
}

sub getScenarioExecutor {
	my ($self) = @_;
	return $self->{scenarioExecutor};
}

sub InitSlpProgress {
	my ($self, $executionSteps, $numberOfExpectedOutputLines) = @_;
	$self->{executionSteps} = $executionSteps;
	$self->{numberOfExpectedOutputLines} = $numberOfExpectedOutputLines;
	$self->{initialProgressOfStep} = 3;

	$self->_setCurrentStepToRunning();
}

sub StepFinished{
    my ($self,$error,$progress) = @_;
    my $currentStep = $self->{executionSteps}->[0];
    return if(!$currentStep);
	if($error){
		$currentStep->setState(STATE_ERROR);
		$currentStep->setProgress($progress);
	} else {
		$currentStep->setState(STATE_FINISHED);
		$currentStep->setProgress(100);
	}
    shift(@{$self->{executionSteps}});
    $self->_setCurrentStepToRunning();
}

sub _setCurrentStepToRunning {
	my ($self) = @_;
	my $currentStep = $self->{executionSteps}->[0];
    if($currentStep){
    	$currentStep->setState(STATE_RUNNING);
    	$currentStep->setProgress($self->{initialProgressOfStep});
	}
}

sub addLine{
    my ($self, $line) = @_;
	if ($line =~ /Downloading\s|Installing\s|Uninstalling\s|Renam\s|Updating\s|Starting|Stopping|All server processes|Importing\s|Creating\s|Add\w*\s|Copying\s|Preparing\s|Extracting\s|Unpacking\s|Configuring\s|Launching\s|Activating\s|Remov\w*\s|^\s*Registering.*|^\s*Unregistering.*|^\s*Regenerating.*|^\s*Deploying.*/){
		$self->getScenarioExecutor()->sendProgressMessage(trim($line));
    }
    unless ($line =~ /Starting\s(\d|on)|Stopping\s(\d|on)/) {
		$self->_updateOverallProgress();
		$self->_updateCurrentStepProgress();
	}
}

sub SetProgress {
	my ($self, $msg) = @_;
	$self->addLine($msg);
}

sub _updateOverallProgress {
	my ($self) = @_;
	my $scenarioExecutor = $self->getScenarioExecutor();
	my $currentProgress = $scenarioExecutor->getProgress();
	my $newProgress = $currentProgress + (100/$self->{numberOfExpectedOutputLines});
	$newProgress = $newProgress < 100 ? $newProgress : 99;
	$scenarioExecutor->sendProgress($newProgress);
}

sub _updateCurrentStepProgress {
	my ($self) = @_;
	my $currentStep = $self->{executionSteps}->[0];
	my $currentStepProgress = $currentStep->getProgress();
	$currentStepProgress += (100 - $self->{initialProgressOfStep}) / ($currentStep->getNumberOfExpectedOutputLines());
	$currentStepProgress = $currentStepProgress < 100 ? $currentStepProgress : 99;
	$currentStep->setProgress($currentStepProgress);
}

1;
