package LCM::Slpp::Update::MediumAnalyzer;

use strict;
use base qw(LCM::MediumAnalyzer);

sub analyze {
    my $self = shift();
    my $configuration = $self->_getConfiguration();

    if ($self->_isDVD()) {
        my $dvdDir = $self->_getDvdDir();
        $configuration->setValue('DvdPath', $dvdDir);
        return 1;
    }
    return $self->SUPER::analyze(@_);
}

sub _handleComponents {
    my ($self, $componentDirs) = @_;
    my $configuration = $self->_getConfiguration();
    my $componentDirsCandidates = join(',', @$componentDirs);

    return 0 if(!$componentDirsCandidates);

    $configuration->{scanner}->scan('ComponentDirs', $componentDirsCandidates);
    $configuration->initializeSelectedComponents();
    $configuration->initializeDetectedComponents();
    return 1;
}

1;