package LCM::Task::CLIProcessTaskMetadata;

use strict;

sub new {
	my ($class, $properties) = @_;
	my $self = bless({}, $class);
	$self->_setRequiresInput($properties->{requiresInput});
	$self->_setRequiresSummary($properties->{requiresSummary});
	$self->_setRequiresConfirmation($properties->{requiresConfirmation});
	$self->_setRequiresLog($properties->{requiresLog});
	$self->_setRequiresHeaderMessage($properties->{requiresHeaderMessage});
	$self->_setMessageBeforeConfirm($properties->{messageBeforeConfirm});
	return $self;
}

sub requiresInput {
	return defined $_[0]->{_requiresInput} ? $_[0]->{_requiresInput} : 1;
}

sub requiresSummary {
	return defined $_[0]->{_requiresSummary} ? $_[0]->{_requiresSummary} : 1;
}

sub requiresConfirmation {
	return defined $_[0]->{_requiresConfirmation} ? $_[0]->{_requiresConfirmation} : 1;
}

sub requiresLog {
	return defined $_[0]->{_requiresLog} ? $_[0]->{_requiresLog} : 1;
}

sub requiresHeaderMessage {
	return defined $_[0]->{_requiresHeaderMessage} ? $_[0]->{_requiresHeaderMessage} : 1;
}

sub getMessageBeforeConfirm {
	return $_[0]->{_messageBeforeConfirm};
}

sub _setRequiresInput {
	my ($self, $requiresInput) = @_;
	$self->{_requiresInput} = $requiresInput;
}

sub _setRequiresSummary {
	my ($self, $requiresSummary) = @_;
	$self->{_requiresSummary} = $requiresSummary;
}

sub _setRequiresConfirmation {
	my ($self, $requiresConfirmation) = @_;
	$self->{_requiresConfirmation} = $requiresConfirmation;
}

sub _setRequiresLog {
	my ($self, $requiresLog) = @_;
	$self->{_requiresLog} = $requiresLog;
}

sub _setRequiresHeaderMessage {
	my ($self, $requiresHeaderMessage) = @_;
	$self->{_requiresHeaderMessage} = $requiresHeaderMessage;
}

sub _setMessageBeforeConfirm {
	my ($self, $messageBeforeConfirm) = @_;
	$self->{_messageBeforeConfirm} = $messageBeforeConfirm;
}

1;